% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write2.R, R/write2.default.R
\name{write2}
\alias{write2}
\alias{write2}
\alias{write2.tableby}
\alias{write2.modelsum}
\alias{write2.freqlist}
\alias{write2.knitr_kable}
\alias{write2.xtable}
\alias{write2.character}
\alias{write2.list}
\alias{write2.verbatim}
\alias{write2.default}
\title{write2}
\usage{
write2(object, file, ..., output_format)

\method{write2}{tableby}(object, file, ..., output_format = NULL)

\method{write2}{modelsum}(object, file, ..., output_format = NULL)

\method{write2}{freqlist}(object, file, ..., output_format = NULL)

\method{write2}{knitr_kable}(object, file, ..., output_format = NULL)

\method{write2}{xtable}(object, file, ..., output_format = NULL)

\method{write2}{character}(object, file, ..., output_format = NULL)

\method{write2}{list}(object, file, ..., append. = FALSE, render. = TRUE,
  keep.md = !render., output_format = NULL)

\method{write2}{verbatim}(object, file, ..., output_format = NULL)

\method{write2}{default}(object, file, FUN = NULL, ..., append. = FALSE,
  render. = TRUE, keep.md = !render., output_format = NULL)
}
\arguments{
\item{object}{An object.}

\item{file}{A single character string denoting the filename for the output document.}

\item{...}{Additional arguments to be passed to \code{FUN}, \code{rmarkdown::render}, etc.
One popular option is to use \code{quiet = TRUE} to suppress the command line output.}

\item{output_format}{One of the following:
\enumerate{
  \item{An output format object, e.g. \code{rmarkdown::\link[rmarkdown]{html_document}(...)}.}
  \item{A character string denoting such a format function, e.g. \code{"html_document"}. In this case, the \code{"..."} are NOT passed.}
  \item{The format function itself, e.g. \code{rmarkdown::html_document}. In this case, the \code{"..."} arguments are passed.}
  \item{One of \code{"html"}, \code{"pdf"}, and \code{"word"}, shortcuts implemented here. In this case, the \code{"..."} arguments are passed.}
  \item{\code{NULL}, in which the output is HTML by default.}
}
See \code{rmarkdown::\link[rmarkdown]{render}} for details.}

\item{append.}{Logical, denoting whether (if a temporary \code{.md} file of the same name already exists)
to append on. Used mostly for \code{write2.list}.}

\item{render.}{Logical, denoting whether to render the temporary \code{.md} file. Used mostly for \code{write2.list}.}

\item{keep.md}{Logical, denoting whether to keep the intermediate \code{.md} file. Used mostly for \code{write2.list}.}

\item{FUN}{The summary-like or print-like function to use to generate the markdown content. Can be passed as a function or a
character string. It's expected that \code{FUN(object, ...)} looks "good" when put directly in a \code{.md} file.}
}
\value{
\code{object} is returned invisibly, and \code{file} is written.
}
\description{
Functions to output tables to a single document. (Also the S3 backbone behind the \code{write2*} functions.)
}
\details{
\code{write2} is an S3 method. The default prints the object (using \code{\link{print}})
   inside a section surrounded by three back ticks. See \code{\link{verbatim}} for details.

   There are methods implemented for \code{\link{tableby}}, \code{\link{modelsum}}, and \code{\link{freqlist}}, all of which use the
   \code{summary} function. There are also methods compatible with \code{\link[knitr]{kable}}, \code{\link[xtable]{xtable}},
   and \code{\link[pander]{pander_return}}. Another option is to coerce an object using \code{\link{verbatim}()} to print out the
   results monospaced (as if they were in the terminal). To output multiple tables into a document, simply make a list of them
   and call the same function as before.

   For more information, see \code{vignette("write2")}.
}
\examples{
\dontrun{
data(mockstudy)
# tableby example
tab1 <- tableby(arm ~ sex + age, data=mockstudy)
write2(tab1, "~/trash.rtf",
  toc = TRUE, # passed to rmarkdown::rtf_document, though in this case it's not practical
  quiet = TRUE, # passed to rmarkdown::render
  title = "My cool new title", # passed to summary.tableby
  output_format = rmarkdown::rtf_document)
}
}
\seealso{
\code{\link{write2word}}, \code{\link{write2pdf}}, \code{\link{write2html}},
  \code{\link[rmarkdown]{render}}, \code{\link[rmarkdown]{word_document}}, \code{\link[rmarkdown]{html_document}}, \code{\link[rmarkdown]{pdf_document}},
  \code{\link[rmarkdown]{rtf_document}}, \code{\link[rmarkdown]{md_document}}, \code{\link[rmarkdown]{odt_document}}
}
\author{
Ethan Heinzen, adapted from code from Krista Goergen
}
