% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.freqlist.R
\name{summary.freqlist}
\alias{summary.freqlist}
\title{summary.freqlist}
\usage{
\method{summary}{freqlist}(object, single = FALSE, labelTranslations = NULL,
  ...)
}
\arguments{
\item{object}{an object of class \code{\link{freqlist}}}

\item{single}{a logical value indicating whether to collapse results created using a groupBy variable into a single table for printing}

\item{labelTranslations}{A character vector giving the labels. Overrides the labels in `freqlist`.}

\item{...}{additional arguments passed to the \code{\link[knitr]{kable}} function}
}
\value{
Invisibly returns \code{object}, and uses \code{\link[knitr]{kable}} to print the object.
}
\description{
Summarize the \code{freqlist} object
}
\examples{
# load mockstudy data
data(mockstudy)
tab.ex <- table(mockstudy[, c("arm", "sex", "mdquality.s")], useNA = "ifany")
noby <- freqlist(tab.ex, na.options = "include")
summary(noby)
withby <- freqlist(tab.ex, groupBy = c("arm","sex"), na.options = "showexclude")
summary(withby)
}
\author{
Tina Gunderson
}
\seealso{
\code{\link[base]{table}}, \code{\link[stats]{xtabs}}, \code{\link[knitr]{kable}}
}

