% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdy.Date.R
\name{mdy.Date}
\alias{Date.mdy}
\alias{mdy.Date}
\title{Convert numeric dates to Date object, and vice versa}
\usage{
mdy.Date(month, day, year, yearcut = 120)

Date.mdy(date)
}
\arguments{
\item{month}{integer, month (1-12).}

\item{day}{integer, day of the month (1-31, depending on the month).}

\item{year}{integer, either 2- or 4-digit year. If two-digit number, will add 1900 onto it, depending on range.}

\item{yearcut}{cutoff for method to know if to convert to 4-digit year.}

\item{date}{A date value.}
}
\value{
\code{mdy.Date} returns a Date object, and Date.mdy returns a list with integer values for month, day, and year.
}
\description{
Convert numeric dates for month, day, and year to Date object, and vice versa.
}
\details{
More work may need to be done with yearcut and 2-digit years. Best to give a full 4-digit year.
}
\examples{
mdy.Date(9, 2, 2013)

tmp <- mdy.Date(9, 2, 2013)
Date.mdy(tmp)
}
\seealso{
\code{\link{Date}}, \code{\link{DateTimeClasses}}
}

