% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipc_stream.R
\name{write_to_raw}
\alias{write_to_raw}
\title{Write Arrow data to a raw vector}
\usage{
write_to_raw(x, format = c("stream", "file"))
}
\arguments{
\item{x}{\code{data.frame}, \link{RecordBatch}, or \link{Table}}

\item{format}{one of \code{c("stream", "file")}, indicating the IPC format to use}
}
\value{
A \code{raw} vector containing the bytes of the IPC serialized data.
}
\description{
\code{\link[=write_ipc_stream]{write_ipc_stream()}} and \code{\link[=write_feather]{write_feather()}} write data to a sink and return
the data (\code{data.frame}, \code{RecordBatch}, or \code{Table}) they were given.
This function wraps those so that you can serialize data to a buffer and
access that buffer as a \code{raw} vector in R.
}
\examples{
\dontshow{if (arrow_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# The default format is "stream"
write_to_raw(mtcars)
write_to_raw(mtcars, format = "file")
\dontshow{\}) # examplesIf}
}
