% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-funcs-augmented.R
\name{add_filename}
\alias{add_filename}
\title{Add the data filename as a column}
\usage{
add_filename()
}
\value{
A \code{FieldRef} \code{\link{Expression}} that refers to the filename
augmented column.
}
\description{
This function only exists inside \code{arrow} \code{dplyr} queries, and it only is
valid when quering on a \code{FileSystemDataset}.
}
\details{
To use filenames generated by this function in subsequent pipeline steps, you
must either call \code{\link[dplyr:compute]{compute()}} or
\code{\link[dplyr:collect]{collect()}} first. See Examples.
}
\examples{
\dontrun{
open_dataset("nyc-taxi") \%>\% mutate(
  file =
    add_filename()
)

# To use a verb like mutate() with add_filename() we need to first call
# compute()
open_dataset("nyc-taxi") \%>\%
  mutate(file = add_filename()) \%>\%
  compute() \%>\%
  mutate(filename_length = nchar(file))
}

}
\keyword{internal}
