% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitions.R
\name{npartitions}
\alias{npartitions}
\title{Number of partitions}
\usage{
npartitions(n, k = NULL, distinct = FALSE, bigz = FALSE)
}
\arguments{
\item{n}{an non-negative integer to be partitioned}

\item{k}{number of parts}

\item{distinct}{an logical to restrict distinct values}

\item{bigz}{an logical to use \link[gmp:bigz]{gmp::bigz}}
}
\description{
Number of partitions
}
\examples{
# number of partitions of 10
npartitions(10)
# number of partitions of 10 into 5 parts
npartitions(10, 5)

# integer overflow
\dontrun{npartitions(160)}
npartitions(160, bigz = TRUE)

# zero sized partitions
npartitions(0)
npartitions(5, 0)
npartitions(5, 6)
npartitions(0, 0)
npartitions(0, 1)
}
\seealso{
\link{partitions} for generating all partitions and \link{ipartitions} for iterating partitions
}
