% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mutators.R
\docType{methods}
\name{mutator}
\alias{mutator}
\alias{get}
\alias{set}
\alias{has_groups}
\alias{has_groups-method}
\alias{get_groups}
\alias{get_groups-method}
\alias{set_groups<-}
\alias{set_groups-method}
\alias{get_samples}
\alias{get_samples-method}
\alias{set_samples<-}
\alias{set_samples-method}
\alias{get_totals}
\alias{get_totals-method}
\alias{set_totals<-}
\alias{set_totals-method}
\alias{has_groups,AbundanceMatrix-method}
\alias{get_groups,AbundanceMatrix-method}
\alias{get_samples,AbundanceMatrix-method}
\alias{get_totals,CompositionMatrix-method}
\alias{get_totals,OccurrenceMatrix-method}
\alias{set_groups<-,AbundanceMatrix-method}
\alias{set_groups,AbundanceMatrix-method}
\alias{set_samples<-,AbundanceMatrix-method}
\alias{set_samples,AbundanceMatrix-method}
\alias{set_totals<-,CompositionMatrix-method}
\alias{set_totals,CompositionMatrix-method}
\title{Get or Set Parts of an Object}
\usage{
has_groups(x)

get_groups(x)

set_groups(x) <- value

get_samples(x)

set_samples(x) <- value

get_totals(x)

set_totals(x) <- value

\S4method{has_groups}{AbundanceMatrix}(x)

\S4method{get_groups}{AbundanceMatrix}(x)

\S4method{get_samples}{AbundanceMatrix}(x)

\S4method{get_totals}{CompositionMatrix}(x)

\S4method{get_totals}{OccurrenceMatrix}(x)

\S4method{set_groups}{AbundanceMatrix}(x) <- value

\S4method{set_samples}{AbundanceMatrix}(x) <- value

\S4method{set_totals}{CompositionMatrix}(x) <- value
}
\arguments{
\item{x}{An object from which to get or set element(s) (typically a
\verb{*Matrix} object).}

\item{value}{A possible value for the element(s) of \code{x}.}
}
\value{
An object of the same sort as \code{x} with the new values assigned.
}
\description{
Getters and setters to retrieve or set parts of an object.
}
\examples{
## Create an incidence (presence/absence) matrix
## Data will be coerced with as.logical()
A <- IncidenceMatrix(data = sample(0:1, 100, TRUE, c(1, 1/3)), nrow = 20)
## Create a count data matrix
B <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 20)

## Access
dim(B) # Get the matrix dimensions
row(B) # Get the row indexes
col(B, as.factor = TRUE) # Get the column indexes
nrow(B) # Get the number of rows
ncol(B) # Get the number of columns
dimnames(B) # Get the dimension names
rownames(B) <- LETTERS[1:20] # Set the row names
rownames(B) # Get the rownames
colnames(B) <- letters[21:25] # Set the column names
colnames(B) # Get the column names

## Subset
B[[1, 1]] # Get the first value
B[1] # Get the first value
B[, ] # Get all values
B[1, , drop = FALSE] # Get the first row
B[, 1:3] # Get the first three column
}
\seealso{
Other mutator: 
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutator}
