% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_encoders.R
\name{set_audio_codec}
\alias{set_audio_codec}
\alias{set_video_codec}
\alias{get_audio_codec}
\alias{get_video_codec}
\alias{audio_codec_encode}
\alias{video_codec_encode}
\title{Set Default Audio and Video Codecs}
\usage{
set_audio_codec(codec)

set_video_codec(codec = "libx264")

get_audio_codec()

get_video_codec()

audio_codec_encode(codec)

video_codec_encode(codec)
}
\arguments{
\item{codec}{The codec to use or get for audio/video.  Uses the
`ffmpeg_audio_codec` and `ffmpeg_video_codec` options
to store this information.}
}
\value{
A `NULL` output
}
\description{
Set Default Audio and Video Codecs
}
\examples{
\dontrun{
if (have_ffmpeg_exec()) {
print(ffmpeg_version())
get_audio_codec()
set_audio_codec(codec = "libfdk_aac")
get_audio_codec()
set_audio_codec(codec = "aac")
get_audio_codec()
}
if (have_ffmpeg_exec()) {
get_video_codec()
set_video_codec(codec = "libx265") 
get_video_codec()
set_video_codec(codec = "libx264")
get_video_codec()
}
## empty thing
if (have_ffmpeg_exec()) {
video_codec_encode("libx264")

audio_codec_encode("aac")
}
}
}
\seealso{
[ffmpeg_codecs()] for options
}
