% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{argo2}
\alias{argo2}
\title{ARGO second step}
\usage{
argo2(truth, argo1.p, argo.nat.p)
}
\arguments{
\item{truth}{prediction target}

\item{argo1.p}{argo first step prediction}

\item{argo.nat.p}{argo national level prediction}
}
\description{
Wrapper for ARGO second step. Best linear predictor / Bayesian posterior
}
\examples{
truth <- xts::xts(exp(matrix(rnorm(180*10), ncol=10)), order.by = Sys.Date() - (180:1))
argo1.p <- xts::xts(exp(matrix(rnorm(180*10), ncol=10)), order.by = Sys.Date() - (180:1))
argo.nat.p <- xts::xts(exp(matrix(rnorm(180*10), ncol=10)), order.by = Sys.Date() - (180:1))
argo2result <- argo2(truth, argo1.p, argo.nat.p)
}
\references{
Shaoyang Ning, Shihao Yang, S. C. Kou. Accurate Regional Influenza Epidemics Tracking Using Internet Search Data. Scientific Reports
}
