% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchOntology.R
\name{matchOntology}
\alias{matchOntology}
\title{Match target terms with an ontology}
\usage{
matchOntology(
  table = NULL,
  columns = NULL,
  dataseries = NULL,
  ontology = NULL,
  verbose = FALSE,
  beep = NULL
)
}
\arguments{
\item{table}{[\code{character(1)}]\cr a table that contains columns that
should be harmonised by matching with the gazetteer.}

\item{columns}{[\code{character(1)}]\cr the columns containing the concepts}

\item{dataseries}{[\code{character(1)}]\cr the source dataseries from which
territories are sourced.}

\item{ontology}{[\code{onto}]\cr either a path where the ontology/gazetteer
is stored, or an already loaded ontology.}

\item{verbose}{[`logical(1)`][logical]\cr whether or not to give detailed
information on the process of this function.}

\item{beep}{[\code{integerish(1)}]\cr Number specifying what sound to be
played to signal the user that a point of interaction is reached by the
program, see \code{\link[beepr]{beep}}.}
}
\value{
Returns a table that resembles the input table where the target
  columns were translated according to the provided ontology.
}
\description{
This function takes a table to replace the values of various columns with
harmonised values listed in the project specific gazetteer.
}
