% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_layers.R
\name{plot_layer,RasterLayer-method}
\alias{plot_layer,RasterLayer-method}
\title{Plot a RasterLayer object}
\usage{
\S4method{plot_layer}{RasterLayer}(
  x,
  outline_poly = NULL,
  outline_size = 1.2,
  outline_color = "gray30",
  legend = TRUE,
  plot_pkg = "ggplot",
  ...
)
}
\arguments{
\item{x}{An sf or Raster* object as returned from a
\code{get_*_layer} function}

\item{outline_poly}{Optional. An sf polygon to outline \code{sf_data} for
context}

\item{outline_size}{Numeric argument that controls width of parameter}

\item{outline_color}{A character vector of a valid color}

\item{legend}{Logical. Only valid when plotting RasterLayers
retrieved from \code{\link{get_map_layer}} where legend was also retrieved}

\item{plot_pkg}{Character. The plotting environment to use. Either "ggplot"
(default) or "base"}

\item{...}{Additional arguments to \code{plot_layer}}
}
\description{
Plot a RasterLayer object
}
\examples{
\dontrun{
wi_landcover <- get_map_layer(wi_landcover_url, wis_poly)
plot_layer(wi_landcover, outline_poly = wis_poly)
}
}
