/* automatically generated by rust-bindgen 0.69.4 */

/* libR-sys version: 0.7.0 */
/* bindgen clang version: Ubuntu clang version 15.0.7 */
/* r version: 4.2.3 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const SINGLESXP: u32 = 302;
pub const HAVE_F77_UNDERSCORE: u32 = 1;
pub const IEEE_754: u32 = 1;
pub const HAVE_VISIBILITY_ATTRIBUTE: u32 = 1;
pub const SUPPORT_UTF8: u32 = 1;
pub const SUPPORT_MBCS: u32 = 1;
pub const ENABLE_NLS: u32 = 1;
pub const SIZEOF_SIZE_T: u32 = 8;
pub const HAVE_ALLOCA_H: u32 = 1;
pub const HAVE_UINTPTR_T: u32 = 1;
pub const R_XLEN_T_MAX: u64 = 4503599627370496;
pub const R_SHORT_LEN_MAX: u32 = 2147483647;
pub const TYPE_BITS: u32 = 5;
pub const MAX_NUM_SEXPTYPE: u32 = 32;
pub const NAMEDMAX: u32 = 7;
pub const R_XDR_DOUBLE_SIZE: u32 = 8;
pub const R_XDR_INTEGER_SIZE: u32 = 4;
pub const R_CODESET_MAX: u32 = 63;
pub const IDENT_NUM_AS_BITS: u32 = 1;
pub const IDENT_NA_AS_BITS: u32 = 2;
pub const IDENT_ATTR_BY_ORDER: u32 = 4;
pub const IDENT_USE_BYTECODE: u32 = 8;
pub const IDENT_USE_CLOENV: u32 = 16;
pub const IDENT_USE_SRCREF: u32 = 32;
pub const IDENT_EXTPTR_AS_REF: u32 = 64;
pub const HT_TYPE_IDENTICAL: u32 = 0;
pub const HT_TYPE_ADDRESS: u32 = 1;
pub const RSTART_VERSION: u32 = 1;
pub const __STDC_WANT_IEC_60559_FUNCS_EXT__: u32 = 1;
pub const R_VERSION_STRING: &[u8; 6] = b"4.2.3\0";
pub const HAVE_EXPM1: u32 = 1;
pub const HAVE_HYPOT: u32 = 1;
pub const HAVE_LOG1P: u32 = 1;
pub const HAVE_WORKING_LOG1P: u32 = 1;
pub const M_SQRT_3: f64 = 1.7320508075688772;
pub const M_SQRT_32: f64 = 5.656854249492381;
pub const M_SQRT_PI: f64 = 1.772453850905516;
pub const M_1_SQRT_2PI: f64 = 0.3989422804014327;
pub const M_SQRT_2dPI: f64 = 0.7978845608028654;
pub const M_LN_2PI: f64 = 1.8378770664093456;
pub const M_LN_SQRT_PI: f64 = 0.5723649429247001;
pub const M_LN_SQRT_2PI: f64 = 0.9189385332046728;
pub const M_LN_SQRT_PId2: f64 = 0.22579135264472744;
pub const R_VERSION: u32 = 262659;
pub const R_NICK: &[u8; 17] = b"Shortstop Beagle\0";
pub const R_MAJOR: &[u8; 2] = b"4\0";
pub const R_MINOR: &[u8; 4] = b"2.3\0";
pub const R_STATUS: &[u8; 1] = b"\0";
pub const R_YEAR: &[u8; 5] = b"2023\0";
pub const R_MONTH: &[u8; 3] = b"03\0";
pub const R_DAY: &[u8; 3] = b"15\0";
pub const R_SVN_REVISION: u32 = 83980;
pub const R_GE_definitions: u32 = 13;
pub const R_GE_deviceClip: u32 = 14;
pub const R_GE_group: u32 = 15;
pub const R_GE_version: u32 = 15;
pub const MAX_GRAPHICS_SYSTEMS: u32 = 24;
pub const R_USE_PROTOTYPES: u32 = 1;
pub const leftButton: u32 = 1;
pub const middleButton: u32 = 2;
pub const rightButton: u32 = 4;
pub const LTY_BLANK: i32 = -1;
pub const LTY_SOLID: u32 = 0;
pub const LTY_DASHED: u32 = 68;
pub const LTY_DOTTED: u32 = 49;
pub const LTY_DOTDASH: u32 = 13361;
pub const LTY_LONGDASH: u32 = 55;
pub const LTY_TWODASH: u32 = 9762;
pub const DEG2RAD: f64 = 0.017453292519943295;
pub const R_GE_linearGradientPattern: u32 = 1;
pub const R_GE_radialGradientPattern: u32 = 2;
pub const R_GE_tilingPattern: u32 = 3;
pub const R_GE_patternExtendPad: u32 = 1;
pub const R_GE_patternExtendRepeat: u32 = 2;
pub const R_GE_patternExtendReflect: u32 = 3;
pub const R_GE_patternExtendNone: u32 = 4;
pub const R_GE_compositeClear: u32 = 1;
pub const R_GE_compositeSource: u32 = 2;
pub const R_GE_compositeOver: u32 = 3;
pub const R_GE_compositeIn: u32 = 4;
pub const R_GE_compositeOut: u32 = 5;
pub const R_GE_compositeAtop: u32 = 6;
pub const R_GE_compositeDest: u32 = 7;
pub const R_GE_compositeDestOver: u32 = 8;
pub const R_GE_compositeDestIn: u32 = 9;
pub const R_GE_compositeDestOut: u32 = 10;
pub const R_GE_compositeDestAtop: u32 = 11;
pub const R_GE_compositeXor: u32 = 12;
pub const R_GE_compositeAdd: u32 = 13;
pub const R_GE_compositeSaturate: u32 = 14;
pub const R_GE_compositeMultiply: u32 = 15;
pub const R_GE_compositeScreen: u32 = 16;
pub const R_GE_compositeOverlay: u32 = 17;
pub const R_GE_compositeDarken: u32 = 18;
pub const R_GE_compositeLighten: u32 = 19;
pub const R_GE_compositeColorDodge: u32 = 20;
pub const R_GE_compositeColorBurn: u32 = 21;
pub const R_GE_compositeHardLight: u32 = 22;
pub const R_GE_compositeSoftLight: u32 = 23;
pub const R_GE_compositeDifference: u32 = 24;
pub const R_GE_compositeExclusion: u32 = 25;
pub const R_GE_nonZeroWindingRule: u32 = 1;
pub const R_GE_evenOddRule: u32 = 2;
pub const R_GE_alphaMask: u32 = 1;
pub const R_GE_luminanceMask: u32 = 2;
pub const R_GE_capability_semiTransparency: u32 = 0;
pub const R_GE_capability_transparentBackground: u32 = 1;
pub const R_GE_capability_rasterImage: u32 = 2;
pub const R_GE_capability_capture: u32 = 3;
pub const R_GE_capability_locator: u32 = 4;
pub const R_GE_capability_events: u32 = 5;
pub const R_GE_capability_patterns: u32 = 6;
pub const R_GE_capability_clippingPaths: u32 = 7;
pub const R_GE_capability_masks: u32 = 8;
pub const R_GE_capability_compositing: u32 = 9;
pub const R_GE_capability_transformations: u32 = 10;
pub const R_GE_capability_paths: u32 = 11;
#[doc = "R_xlen_t is defined as int on 32-bit platforms, and\n that confuses Rust. Keeping it always as ptrdiff_t works\n fine even on 32-bit.\n <div rustbindgen replaces=\"R_xlen_t\"></div>"]
pub type R_xlen_t = isize;
pub type va_list = __builtin_va_list;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Rboolean {
    #[doc = ", MAYBE"]
    FALSE = 0,
    #[doc = ", MAYBE"]
    TRUE = 1,
}
#[doc = "Called with a variable argument set after casting to a compatible\nfunction pointer."]
pub type DL_FUNC = ::std::option::Option<unsafe extern "C" fn() -> *mut ::std::os::raw::c_void>;
pub type R_NativePrimitiveArgType = ::std::os::raw::c_uint;
#[doc = "These are very similar to those in Rdynpriv.h,\nbut we maintain them separately to give us more freedom to do\nsome computations on the internal versions that are derived from\nthese definitions."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_CMethodDef {
    pub name: *const ::std::os::raw::c_char,
    pub fun: DL_FUNC,
    pub numArgs: ::std::os::raw::c_int,
    pub types: *mut R_NativePrimitiveArgType,
}
#[doc = "These are very similar to those in Rdynpriv.h,\nbut we maintain them separately to give us more freedom to do\nsome computations on the internal versions that are derived from\nthese definitions."]
pub type R_FortranMethodDef = R_CMethodDef;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_CallMethodDef {
    pub name: *const ::std::os::raw::c_char,
    pub fun: DL_FUNC,
    pub numArgs: ::std::os::raw::c_int,
}
pub type R_ExternalMethodDef = R_CallMethodDef;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DllInfo {
    _unused: [u8; 0],
}
pub type DllInfo = _DllInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Rf_RegisteredNativeSymbol {
    _unused: [u8; 0],
}
pub type R_RegisteredNativeSymbol = Rf_RegisteredNativeSymbol;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum NativeSymbolType {
    R_ANY_SYM = 0,
    R_C_SYM = 1,
    R_CALL_SYM = 2,
    R_FORTRAN_SYM = 3,
    R_EXTERNAL_SYM = 4,
}
pub type Rbyte = ::std::os::raw::c_uchar;
#[doc = "type for length of (standard, not long) vectors etc"]
pub type R_len_t = ::std::os::raw::c_int;
#[repr(u32)]
#[doc = "------ enum_SEXPTYPE -----"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SEXPTYPE {
    #[doc = "nil = NULL"]
    NILSXP = 0,
    #[doc = "symbols"]
    SYMSXP = 1,
    #[doc = "lists of dotted pairs"]
    LISTSXP = 2,
    #[doc = "closures"]
    CLOSXP = 3,
    #[doc = "environments"]
    ENVSXP = 4,
    #[doc = "promises: \\[un\\]evaluated closure arguments"]
    PROMSXP = 5,
    #[doc = "language constructs (special lists)"]
    LANGSXP = 6,
    #[doc = "special forms"]
    SPECIALSXP = 7,
    #[doc = "builtin non-special forms"]
    BUILTINSXP = 8,
    #[doc = "\"scalar\" string type (internal only)"]
    CHARSXP = 9,
    #[doc = "logical vectors"]
    LGLSXP = 10,
    #[doc = "integer vectors"]
    INTSXP = 13,
    #[doc = "real variables"]
    REALSXP = 14,
    #[doc = "complex variables"]
    CPLXSXP = 15,
    #[doc = "string vectors"]
    STRSXP = 16,
    #[doc = "dot-dot-dot object"]
    DOTSXP = 17,
    #[doc = "make \"any\" args work"]
    ANYSXP = 18,
    #[doc = "generic vectors"]
    VECSXP = 19,
    #[doc = "expressions vectors"]
    EXPRSXP = 20,
    #[doc = "byte code"]
    BCODESXP = 21,
    #[doc = "external pointer"]
    EXTPTRSXP = 22,
    #[doc = "weak reference"]
    WEAKREFSXP = 23,
    #[doc = "raw bytes"]
    RAWSXP = 24,
    #[doc = "S4 non-vector"]
    S4SXP = 25,
    #[doc = "fresh node creaed in new page"]
    NEWSXP = 30,
    #[doc = "node released by GC"]
    FREESXP = 31,
    #[doc = "Closure or Builtin"]
    FUNSXP = 99,
}
pub type SEXP = *mut SEXPREC;
#[doc = "We sometimes need to coerce a protected value and place the new\ncoerced value under protection.  For these cases PROTECT_WITH_INDEX\nsaves an index of the protection location that can be used to\nreplace the protected value using REPROTECT."]
pub type PROTECT_INDEX = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_allocator {
    _unused: [u8; 0],
}
pub type R_allocator_t = R_allocator;
#[repr(u32)]
#[doc = "../main/character.c :"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum nchar_type {
    Bytes = 0,
    Chars = 1,
    Width = 2,
}
#[repr(u32)]
#[doc = "cetype_t is an identifier reseved by POSIX, but it is\nwell established as public.  Could remap by a #define though"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cetype_t {
    CE_NATIVE = 0,
    CE_UTF8 = 1,
    CE_LATIN1 = 2,
    CE_BYTES = 3,
    CE_SYMBOL = 5,
    CE_ANY = 99,
}
#[doc = "Finalization interface"]
pub type R_CFinalizer_t = ::std::option::Option<unsafe extern "C" fn(arg1: SEXP)>;
pub type R_pstream_data_t = *mut ::std::os::raw::c_void;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum R_pstream_format_t {
    R_pstream_any_format = 0,
    R_pstream_ascii_format = 1,
    R_pstream_binary_format = 2,
    R_pstream_xdr_format = 3,
    R_pstream_asciihex_format = 4,
}
pub type R_outpstream_t = *mut R_outpstream_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_outpstream_st {
    pub data: R_pstream_data_t,
    pub type_: R_pstream_format_t,
    pub version: ::std::os::raw::c_int,
    pub OutChar: ::std::option::Option<
        unsafe extern "C" fn(arg1: R_outpstream_t, arg2: ::std::os::raw::c_int),
    >,
    pub OutBytes: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: R_outpstream_t,
            arg2: *mut ::std::os::raw::c_void,
            arg3: ::std::os::raw::c_int,
        ),
    >,
    pub OutPersistHookFunc:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
    pub OutPersistHookData: SEXP,
}
pub type R_inpstream_t = *mut R_inpstream_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_inpstream_st {
    pub data: R_pstream_data_t,
    pub type_: R_pstream_format_t,
    pub InChar:
        ::std::option::Option<unsafe extern "C" fn(arg1: R_inpstream_t) -> ::std::os::raw::c_int>,
    pub InBytes: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: R_inpstream_t,
            arg2: *mut ::std::os::raw::c_void,
            arg3: ::std::os::raw::c_int,
        ),
    >,
    pub InPersistHookFunc:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
    pub InPersistHookData: SEXP,
    pub native_encoding: [::std::os::raw::c_char; 64usize],
    pub nat2nat_obj: *mut ::std::os::raw::c_void,
    pub nat2utf8_obj: *mut ::std::os::raw::c_void,
}
pub const SORTED_DECR_NA_1ST: _bindgen_ty_2 = _bindgen_ty_2::SORTED_DECR_NA_1ST;
pub const SORTED_DECR: _bindgen_ty_2 = _bindgen_ty_2::SORTED_DECR;
pub const UNKNOWN_SORTEDNESS: _bindgen_ty_2 = _bindgen_ty_2::UNKNOWN_SORTEDNESS;
pub const SORTED_INCR: _bindgen_ty_2 = _bindgen_ty_2::SORTED_INCR;
pub const SORTED_INCR_NA_1ST: _bindgen_ty_2 = _bindgen_ty_2::SORTED_INCR_NA_1ST;
pub const KNOWN_UNSORTED: _bindgen_ty_2 = _bindgen_ty_2::KNOWN_UNSORTED;
#[repr(i32)]
#[doc = "ALTREP sorting support"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_2 {
    SORTED_DECR_NA_1ST = -2,
    SORTED_DECR = -1,
    #[doc = "INT_MIN is NA_INTEGER!"]
    UNKNOWN_SORTEDNESS = -2147483648,
    SORTED_INCR = 1,
    SORTED_INCR_NA_1ST = 2,
    KNOWN_UNSORTED = 0,
}
#[doc = "try to allow some type checking"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_hashtab_type {
    pub cell: SEXP,
}
#[repr(u32)]
#[doc = "Startup Actions"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SA_TYPE {
    #[doc = "= 0"]
    SA_NORESTORE = 0,
    SA_RESTORE = 1,
    #[doc = "was === SA_RESTORE"]
    SA_DEFAULT = 2,
    SA_NOSAVE = 3,
    SA_SAVE = 4,
    SA_SAVEASK = 5,
    SA_SUICIDE = 6,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct structRstart {
    pub R_Quiet: Rboolean,
    pub R_NoEcho: Rboolean,
    pub R_Interactive: Rboolean,
    pub R_Verbose: Rboolean,
    pub LoadSiteFile: Rboolean,
    pub LoadInitFile: Rboolean,
    pub DebugInitFile: Rboolean,
    pub RestoreAction: SA_TYPE,
    pub SaveAction: SA_TYPE,
    pub vsize: usize,
    pub nsize: usize,
    pub max_vsize: usize,
    pub max_nsize: usize,
    pub ppsize: usize,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
impl structRstart {
    #[inline]
    pub fn NoRenviron(&self) -> Rboolean {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_NoRenviron(&mut self, val: Rboolean) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn RstartVersion(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_RstartVersion(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        NoRenviron: Rboolean,
        RstartVersion: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let NoRenviron: u32 = unsafe { ::std::mem::transmute(NoRenviron) };
            NoRenviron as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let RstartVersion: u32 = unsafe { ::std::mem::transmute(RstartVersion) };
            RstartVersion as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type Rstart = *mut structRstart;
#[repr(u32)]
#[doc = "PARSE_NULL will not be returned by R_ParseVector"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ParseStatus {
    PARSE_NULL = 0,
    PARSE_OK = 1,
    PARSE_INCOMPLETE = 2,
    PARSE_ERROR = 3,
    PARSE_EOF = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_altrep_class_t {
    pub ptr: SEXP,
}
pub type R_altrep_UnserializeEX_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: SEXP,
        arg3: SEXP,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> SEXP,
>;
pub type R_altrep_Unserialize_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>;
pub type R_altrep_Serialized_state_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> SEXP>;
pub type R_altrep_DuplicateEX_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altrep_Duplicate_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altrep_Inspect_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: SEXP,
                arg2: ::std::os::raw::c_int,
                arg3: ::std::os::raw::c_int,
                arg4: ::std::os::raw::c_int,
            ),
        >,
    ) -> Rboolean,
>;
pub type R_altrep_Length_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> R_xlen_t>;
pub type R_altvec_Dataptr_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> *mut ::std::os::raw::c_void,
>;
pub type R_altvec_Dataptr_or_null_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> *const ::std::os::raw::c_void>;
pub type R_altvec_Extract_subset_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP>;
pub type R_altinteger_Elt_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> ::std::os::raw::c_int,
>;
pub type R_altinteger_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t,
>;
pub type R_altinteger_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altinteger_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altinteger_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altinteger_Min_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altinteger_Max_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> f64>;
pub type R_altreal_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: R_xlen_t, arg4: *mut f64) -> R_xlen_t,
>;
pub type R_altreal_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altreal_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altreal_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Min_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Max_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altlogical_Elt_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> ::std::os::raw::c_int,
>;
pub type R_altlogical_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t,
>;
pub type R_altlogical_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altlogical_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altlogical_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altraw_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> Rbyte>;
pub type R_altraw_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: R_xlen_t, arg4: *mut Rbyte) -> R_xlen_t,
>;
pub type R_altcomplex_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> Rcomplex>;
pub type R_altcomplex_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut Rcomplex,
    ) -> R_xlen_t,
>;
pub type R_altstring_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> SEXP>;
pub type R_altstring_Set_elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: SEXP)>;
pub type R_altstring_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altstring_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
#[repr(u32)]
#[doc = "The graphics engine will only accept locations and dimensions\n in native device coordinates, but it provides the following functions\n for converting between a couple of simple alternative coordinate\n systems and device coordinates:\n    DEVICE = native units of the device\n    NDC = Normalised device coordinates\n    INCHES = inches (!)\n    CM = centimetres (!!)"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GEUnit {
    #[doc = "native device coordinates (rasters)"]
    GE_DEVICE = 0,
    #[doc = "normalised device coordinates x=(0,1), y=(0,1)"]
    GE_NDC = 1,
    GE_INCHES = 2,
    GE_CM = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GEevent {
    #[doc = "In response to this event, the registered graphics system\n should allocate and initialise the systemSpecific structure\n\n Should return R_NilValue on failure so that engine\n can tidy up memory allocation"]
    GE_InitState = 0,
    #[doc = "This event gives the registered system a chance to undo\n anything done in the initialisation."]
    GE_FinaliseState = 1,
    #[doc = "This is sent by the graphics engine prior to initialising\n the display list.  It give the graphics system the chance\n to squirrel away information it will need for redrawing the\n the display list"]
    GE_SaveState = 2,
    #[doc = "This is sent by the graphics engine prior to replaying the\n display list.  It gives the graphics system the chance to\n restore any information it saved on the GE_SaveState event"]
    GE_RestoreState = 6,
    #[doc = "Copy system state information to the current device.\n This is used when copying graphics from one device to another\n so all the graphics system needs to do is to copy across\n the bits required for the display list to draw faithfully\n on the new device."]
    GE_CopyState = 3,
    #[doc = "Create a snapshot of the system state that is sufficient\n for the current \"image\" to be reproduced"]
    GE_SaveSnapshotState = 4,
    #[doc = "Restore the system state that is saved by GE_SaveSnapshotState"]
    GE_RestoreSnapshotState = 5,
    #[doc = "When replaying the display list, the graphics engine\n checks, after each replayed action, that the action\n produced valid output.  This is the graphics system's\n chance to say that the output is crap (in which case the\n graphics engine will abort the display list replay)."]
    GE_CheckPlot = 7,
    #[doc = "The device wants to scale the current pointsize\n (for scaling an image)\n This is not a nice general solution, but a quick fix for\n the Windows device."]
    GE_ScalePS = 8,
}
#[repr(u32)]
#[doc = "Some line end/join constants"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum R_GE_lineend {
    GE_ROUND_CAP = 1,
    GE_BUTT_CAP = 2,
    GE_SQUARE_CAP = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum R_GE_linejoin {
    GE_ROUND_JOIN = 1,
    GE_MITRE_JOIN = 2,
    GE_BEVEL_JOIN = 3,
}
#[doc = "A structure containing graphical parameters\n\n This is how graphical parameters are passed from graphics systems\n to the graphics engine AND from the graphics engine to graphics\n devices.\n\n Devices are not *required* to honour graphical parameters\n (e.g., alpha transparency is going to be tough for some)"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_GE_gcontext {
    #[doc = "pen colour (lines, text, borders, ...)"]
    pub col: ::std::os::raw::c_int,
    #[doc = "fill colour (for polygons, circles, rects, ...)"]
    pub fill: ::std::os::raw::c_int,
    #[doc = "Gamma correction"]
    pub gamma: f64,
    #[doc = "Line width (roughly number of pixels)"]
    pub lwd: f64,
    #[doc = "Line type (solid, dashed, dotted, ...)"]
    pub lty: ::std::os::raw::c_int,
    #[doc = "Line end"]
    pub lend: R_GE_lineend,
    #[doc = "line join"]
    pub ljoin: R_GE_linejoin,
    #[doc = "line mitre"]
    pub lmitre: f64,
    #[doc = "Character expansion (font size = fontsize*cex)"]
    pub cex: f64,
    #[doc = "Font size in points"]
    pub ps: f64,
    #[doc = "Line height (multiply by font size)"]
    pub lineheight: f64,
    #[doc = "Font face (plain, italic, bold, ...)"]
    pub fontface: ::std::os::raw::c_int,
    #[doc = "Font family"]
    pub fontfamily: [::std::os::raw::c_char; 201usize],
    #[doc = "Reference to a pattern fill"]
    pub patternFill: SEXP,
}
pub type pGEcontext = *mut R_GE_gcontext;
#[doc = "--------- New (in 1.4.0) device driver structure ---------\n NOTES:\n 1. All locations and dimensions are in device coordinates.\n 2. I found this comment in the doc for dev_Open -- looks nasty\n    Any known instances of such a thing happening?  Should be\n    replaced by a function to query the device for preferred gpars\n    settings? (to be called when the device is initialised)\n\n NOTE that it is perfectly acceptable for this\n function to set generic graphics parameters too\n (i.e., override the generic parameter settings\n which GInit sets up) all at the author's own risk\n of course :)\n\n 3. Do we really need dev_StrWidth as well as dev_MetricInfo?\n    I can see the difference between the two -- its just a\n    question of whether dev_MetricInfo should just return\n    what dev_StrWidth would give if font metric information is\n    not available.  I guess having both allows the developer\n    to decide when to ask for which sort of value, and to decide\n    what to do when font metric information is not available.\n    And why not a dev_StrHeight?\n 4. Should \"ipr\", \"asp\", and \"cra\" be in the device description?\n    If not, then where?\n    I guess they don't need to be if no device makes use of them.\n    On the other hand, they would need to be replaced by a device\n    call that R base graphics could use to get enough information\n    to figure them out.  (e.g., some sort of dpi() function to\n    complement the size() function.)"]
pub type DevDesc = _DevDesc;
pub type pDevDesc = *mut DevDesc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DevDesc {
    #[doc = "left raster coordinate"]
    pub left: f64,
    #[doc = "right raster coordinate"]
    pub right: f64,
    #[doc = "bottom raster coordinate"]
    pub bottom: f64,
    #[doc = "top raster coordinate"]
    pub top: f64,
    #[doc = "R only has the notion of a rectangular clipping region"]
    pub clipLeft: f64,
    pub clipRight: f64,
    pub clipBottom: f64,
    pub clipTop: f64,
    #[doc = "x character addressing offset - unused"]
    pub xCharOffset: f64,
    #[doc = "y character addressing offset"]
    pub yCharOffset: f64,
    #[doc = "1/2 interline space as frac of line height"]
    pub yLineBias: f64,
    #[doc = "Inches per raster; \\[0\\]=x, \\[1\\]=y"]
    pub ipr: [f64; 2usize],
    #[doc = "Character size in rasters; \\[0\\]=x, \\[1\\]=y"]
    pub cra: [f64; 2usize],
    #[doc = "(initial) Device Gamma Correction"]
    pub gamma: f64,
    #[doc = "Device-level clipping"]
    pub canClip: Rboolean,
    #[doc = "can the gamma factor be modified?"]
    pub canChangeGamma: Rboolean,
    #[doc = "Can do at least some horiz adjust of text\n0 = none, 1 = {0,0.5,1}, 2 = \\[0,1\\]"]
    pub canHAdj: ::std::os::raw::c_int,
    #[doc = "Device initial settings\n/\n/* These are things that the device must set up when it is created.\n The graphics system can modify them and track current values,"]
    pub startps: f64,
    #[doc = "sets par(\"fg\"), par(\"col\") and gpar(\"col\")"]
    pub startcol: ::std::os::raw::c_int,
    #[doc = "sets par(\"bg\") and gpar(\"fill\")"]
    pub startfill: ::std::os::raw::c_int,
    pub startlty: ::std::os::raw::c_int,
    pub startfont: ::std::os::raw::c_int,
    pub startgamma: f64,
    #[doc = "pointer to device specific parameters"]
    pub deviceSpecific: *mut ::std::os::raw::c_void,
    #[doc = "toggle for initial display list status"]
    pub displayListOn: Rboolean,
    #[doc = "can the device generate mousedown events"]
    pub canGenMouseDown: Rboolean,
    #[doc = "can the device generate mousemove events"]
    pub canGenMouseMove: Rboolean,
    #[doc = "can the device generate mouseup events"]
    pub canGenMouseUp: Rboolean,
    #[doc = "can the device generate keyboard events"]
    pub canGenKeybd: Rboolean,
    #[doc = "can the device generate idle events"]
    pub canGenIdle: Rboolean,
    #[doc = "This is set while getGraphicsEvent\nis actively looking for events"]
    pub gettingEvent: Rboolean,
    pub activate: ::std::option::Option<unsafe extern "C" fn(arg1: pDevDesc)>,
    pub circle: ::std::option::Option<
        unsafe extern "C" fn(x: f64, y: f64, r: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub clip: ::std::option::Option<
        unsafe extern "C" fn(x0: f64, x1: f64, y0: f64, y1: f64, dd: pDevDesc),
    >,
    pub close: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc)>,
    pub deactivate: ::std::option::Option<unsafe extern "C" fn(arg1: pDevDesc)>,
    pub locator: ::std::option::Option<
        unsafe extern "C" fn(x: *mut f64, y: *mut f64, dd: pDevDesc) -> Rboolean,
    >,
    pub line: ::std::option::Option<
        unsafe extern "C" fn(x1: f64, y1: f64, x2: f64, y2: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub metricInfo: ::std::option::Option<
        unsafe extern "C" fn(
            c: ::std::os::raw::c_int,
            gc: pGEcontext,
            ascent: *mut f64,
            descent: *mut f64,
            width: *mut f64,
            dd: pDevDesc,
        ),
    >,
    pub mode:
        ::std::option::Option<unsafe extern "C" fn(mode: ::std::os::raw::c_int, dd: pDevDesc)>,
    pub newPage: ::std::option::Option<unsafe extern "C" fn(gc: pGEcontext, dd: pDevDesc)>,
    pub polygon: ::std::option::Option<
        unsafe extern "C" fn(
            n: ::std::os::raw::c_int,
            x: *mut f64,
            y: *mut f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub polyline: ::std::option::Option<
        unsafe extern "C" fn(
            n: ::std::os::raw::c_int,
            x: *mut f64,
            y: *mut f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub rect: ::std::option::Option<
        unsafe extern "C" fn(x0: f64, y0: f64, x1: f64, y1: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub path: ::std::option::Option<
        unsafe extern "C" fn(
            x: *mut f64,
            y: *mut f64,
            npoly: ::std::os::raw::c_int,
            nper: *mut ::std::os::raw::c_int,
            winding: Rboolean,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub raster: ::std::option::Option<
        unsafe extern "C" fn(
            raster: *mut ::std::os::raw::c_uint,
            w: ::std::os::raw::c_int,
            h: ::std::os::raw::c_int,
            x: f64,
            y: f64,
            width: f64,
            height: f64,
            rot: f64,
            interpolate: Rboolean,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub cap: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc) -> SEXP>,
    pub size: ::std::option::Option<
        unsafe extern "C" fn(
            left: *mut f64,
            right: *mut f64,
            bottom: *mut f64,
            top: *mut f64,
            dd: pDevDesc,
        ),
    >,
    pub strWidth: ::std::option::Option<
        unsafe extern "C" fn(
            str_: *const ::std::os::raw::c_char,
            gc: pGEcontext,
            dd: pDevDesc,
        ) -> f64,
    >,
    pub text: ::std::option::Option<
        unsafe extern "C" fn(
            x: f64,
            y: f64,
            str_: *const ::std::os::raw::c_char,
            rot: f64,
            hadj: f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub onExit: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc)>,
    #[doc = "device_getEvent is no longer used, but the slot is kept for back\n compatibility of the structure."]
    pub getEvent: ::std::option::Option<
        unsafe extern "C" fn(arg1: SEXP, arg2: *const ::std::os::raw::c_char) -> SEXP,
    >,
    pub newFrameConfirm: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc) -> Rboolean>,
    #[doc = "and strWidthUTF8"]
    pub hasTextUTF8: Rboolean,
    pub textUTF8: ::std::option::Option<
        unsafe extern "C" fn(
            x: f64,
            y: f64,
            str_: *const ::std::os::raw::c_char,
            rot: f64,
            hadj: f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub strWidthUTF8: ::std::option::Option<
        unsafe extern "C" fn(
            str_: *const ::std::os::raw::c_char,
            gc: pGEcontext,
            dd: pDevDesc,
        ) -> f64,
    >,
    pub wantSymbolUTF8: Rboolean,
    #[doc = "Is rotated text good enough to be preferable to Hershey in\ncontour labels?  Old default was FALSE."]
    pub useRotatedTextInContour: Rboolean,
    #[doc = "This is an environment holding event handlers."]
    pub eventEnv: SEXP,
    pub eventHelper:
        ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc, code: ::std::os::raw::c_int)>,
    pub holdflush: ::std::option::Option<
        unsafe extern "C" fn(dd: pDevDesc, level: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
    >,
    #[doc = "1 = no, 2 = yes"]
    pub haveTransparency: ::std::os::raw::c_int,
    #[doc = "1 = no, 2 = fully, 3 = semi"]
    pub haveTransparentBg: ::std::os::raw::c_int,
    #[doc = "1 = no, 2 = yes, 3 = except for missing values"]
    pub haveRaster: ::std::os::raw::c_int,
    #[doc = "1 = no, 2 = yes"]
    pub haveCapture: ::std::os::raw::c_int,
    #[doc = "1 = no, 2 = yes"]
    pub haveLocator: ::std::os::raw::c_int,
    pub setPattern:
        ::std::option::Option<unsafe extern "C" fn(pattern: SEXP, dd: pDevDesc) -> SEXP>,
    pub releasePattern: ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, dd: pDevDesc)>,
    pub setClipPath:
        ::std::option::Option<unsafe extern "C" fn(path: SEXP, ref_: SEXP, dd: pDevDesc) -> SEXP>,
    pub releaseClipPath: ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, dd: pDevDesc)>,
    pub setMask:
        ::std::option::Option<unsafe extern "C" fn(path: SEXP, ref_: SEXP, dd: pDevDesc) -> SEXP>,
    pub releaseMask: ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, dd: pDevDesc)>,
    #[doc = "This should match R_GE_version,\n BUT it does not have to.\n It give the graphics engine a chance to work with\n graphics device packages BEFORE they update to\n changes in R_GE_version."]
    pub deviceVersion: ::std::os::raw::c_int,
    #[doc = "This can be used to OVERRIDE canClip so that graphics engine\n leaves ALL clipping to the graphics device"]
    pub deviceClip: Rboolean,
    pub defineGroup: ::std::option::Option<
        unsafe extern "C" fn(
            source: SEXP,
            op: ::std::os::raw::c_int,
            destination: SEXP,
            dd: pDevDesc,
        ) -> SEXP,
    >,
    pub useGroup:
        ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, trans: SEXP, dd: pDevDesc)>,
    pub releaseGroup: ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, dd: pDevDesc)>,
    pub stroke:
        ::std::option::Option<unsafe extern "C" fn(path: SEXP, gc: pGEcontext, dd: pDevDesc)>,
    pub fill: ::std::option::Option<
        unsafe extern "C" fn(path: SEXP, rule: ::std::os::raw::c_int, gc: pGEcontext, dd: pDevDesc),
    >,
    pub fillStroke: ::std::option::Option<
        unsafe extern "C" fn(path: SEXP, rule: ::std::os::raw::c_int, gc: pGEcontext, dd: pDevDesc),
    >,
    pub capabilities: ::std::option::Option<unsafe extern "C" fn(cap: SEXP) -> SEXP>,
    #[doc = "Area for future expansion.\nBy zeroing this, devices are more likely to work if loaded\ninto a later version of R than that they were compiled under."]
    pub reserved: [::std::os::raw::c_char; 64usize],
}
#[repr(i32)]
#[doc = "These give the indices of some known keys"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum R_KeyName {
    knUNKNOWN = -1,
    knLEFT = 0,
    knUP = 1,
    knRIGHT = 2,
    knDOWN = 3,
    knF1 = 4,
    knF2 = 5,
    knF3 = 6,
    knF4 = 7,
    knF5 = 8,
    knF6 = 9,
    knF7 = 10,
    knF8 = 11,
    knF9 = 12,
    knF10 = 13,
    knF11 = 14,
    knF12 = 15,
    knPGUP = 16,
    knPGDN = 17,
    knEND = 18,
    knHOME = 19,
    knINS = 20,
    knDEL = 21,
}
#[repr(u32)]
#[doc = "These are the three possible mouse events"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum R_MouseEvent {
    meMouseDown = 0,
    meMouseUp = 1,
    meMouseMove = 2,
}
pub type GEDevDesc = _GEDevDesc;
pub type GEcallback = ::std::option::Option<
    unsafe extern "C" fn(arg1: GEevent, arg2: *mut GEDevDesc, arg3: SEXP) -> SEXP,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GESystemDesc {
    #[doc = "An array of information about each graphics system that\n has registered with the graphics engine.\n This is used to store graphics state for each graphics\n system on each device."]
    pub systemSpecific: *mut ::std::os::raw::c_void,
    #[doc = "An array of function pointers, one per graphics system that\n has registered with the graphics engine.\n\n system_Callback is called when the graphics engine wants\n to give a graphics system the chance to play with its\n device-specific information (stored in systemSpecific)\n There are two parameters:  an \"event\" to tell the graphics\n system why the graphics engine has called this function,\n and the systemSpecific pointer.  The graphics engine\n has to pass the systemSpecific pointer because only\n the graphics engine will know what array index to use."]
    pub callback: GEcallback,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GEDevDesc {
    #[doc = "Stuff that the devices can see (and modify).\n All detailed in GraphicsDevice.h"]
    pub dev: pDevDesc,
    #[doc = "toggle for display list status"]
    pub displayListOn: Rboolean,
    #[doc = "display list"]
    pub displayList: SEXP,
    #[doc = "A pointer to the end of the display list\nto avoid tranversing pairlists"]
    pub DLlastElt: SEXP,
    #[doc = "The last element of the display list\n just prior to when the display list\n was last initialised"]
    pub savedSnapshot: SEXP,
    #[doc = "Has the device received any output?"]
    pub dirty: Rboolean,
    #[doc = "Should a graphics call be stored\n on the display list?\n Set to FALSE by do_recordGraphics,\n do_dotcallgr, and do_Externalgr\n so that nested calls are not\n recorded on the display list"]
    pub recordGraphics: Rboolean,
    #[doc = "Stuff about the device that only graphics systems see.\n The graphics engine has no idea what is in here.\n Used by graphics systems to store system state per device."]
    pub gesd: [*mut GESystemDesc; 24usize],
    #[doc = "per-device setting for 'ask' (use NewFrameConfirm)"]
    pub ask: Rboolean,
    #[doc = "Is a device appending a path ?"]
    pub appending: Rboolean,
}
pub type pGEDevDesc = *mut GEDevDesc;
#[doc = "-------------------------------------------------------------------\n\n  COLOUR CODE is concerned with the internals of R colour representation\n\n  From colors.c, used in par.c, grid/src/gpar.c"]
pub type rcolor = ::std::os::raw::c_uint;
#[doc = "../../appl/integrate.c"]
pub type integr_fn = ::std::option::Option<
    unsafe extern "C" fn(x: *mut f64, n: ::std::os::raw::c_int, ex: *mut ::std::os::raw::c_void),
>;
#[doc = "main/optim.c"]
pub type optimfn = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: *mut f64,
        arg3: *mut ::std::os::raw::c_void,
    ) -> f64,
>;
pub type optimgr = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: *mut f64,
        arg3: *mut f64,
        arg4: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = "type of pointer to the target and gradient functions"]
pub type fcn_p = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: *mut f64,
        arg3: *mut f64,
        arg4: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = "type of pointer to the hessian functions"]
pub type d2fcn_p = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut f64,
        arg4: *mut f64,
        arg5: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RNGtype {
    WICHMANN_HILL = 0,
    MARSAGLIA_MULTICARRY = 1,
    SUPER_DUPER = 2,
    MERSENNE_TWISTER = 3,
    KNUTH_TAOCP = 4,
    USER_UNIF = 5,
    KNUTH_TAOCP2 = 6,
    LECUYER_CMRG = 7,
}
#[repr(u32)]
#[doc = "Different kinds of \"N(0,1)\" generators :"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum N01type {
    BUGGY_KINDERMAN_RAMAGE = 0,
    AHRENS_DIETER = 1,
    BOX_MULLER = 2,
    USER_NORM = 3,
    INVERSION = 4,
    KINDERMAN_RAMAGE = 5,
}
#[repr(u32)]
#[doc = "Different ways to generate discrete uniform samples"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum Sampletype {
    ROUNDING = 0,
    REJECTION = 1,
}
pub type Int32 = ::std::os::raw::c_uint;
#[doc = "R 4.3 redefined `Rcomplex` to a union for compatibility with Fortran.\n But the old definition is compatible both the union version\n and the struct version.\n See: <https://github.com/extendr/extendr/issues/524>\n <div rustbindgen replaces=\"Rcomplex\"></div>"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Rcomplex {
    pub r: f64,
    pub i: f64,
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
extern "C" {
    #[doc = "IEEE NaN"]
    pub static mut R_NaN: f64;
    #[doc = "IEEE Inf"]
    pub static mut R_PosInf: f64;
    #[doc = "IEEE -Inf"]
    pub static mut R_NegInf: f64;
    #[doc = "NA_REAL: IEEE"]
    pub static mut R_NaReal: f64;
    #[doc = "NA_INTEGER:= INT_MIN currently"]
    pub static mut R_NaInt: ::std::os::raw::c_int;
    #[doc = "NA_STRING is a SEXP, so defined in Rinternals.h"]
    pub fn R_IsNA(arg1: f64) -> ::std::os::raw::c_int;
    pub fn R_IsNaN(arg1: f64) -> ::std::os::raw::c_int;
    pub fn R_finite(arg1: f64) -> ::std::os::raw::c_int;
    pub fn Rf_error(arg1: *const ::std::os::raw::c_char, ...) -> !;
    pub fn UNIMPLEMENTED(arg1: *const ::std::os::raw::c_char) -> !;
    pub fn WrongArgCount(arg1: *const ::std::os::raw::c_char) -> !;
    pub fn Rf_warning(arg1: *const ::std::os::raw::c_char, ...);
    pub fn R_ShowMessage(s: *const ::std::os::raw::c_char);
    pub fn vmaxget() -> *mut ::std::os::raw::c_void;
    pub fn vmaxset(arg1: *const ::std::os::raw::c_void);
    pub fn R_gc();
    pub fn R_gc_running() -> ::std::os::raw::c_int;
    pub fn R_alloc(arg1: usize, arg2: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
    pub fn R_allocLD(nelem: usize) -> *mut u128;
    pub fn S_alloc(
        arg1: ::std::os::raw::c_long,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
    pub fn S_realloc(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_long,
        arg4: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
    pub fn R_malloc_gc(arg1: usize) -> *mut ::std::os::raw::c_void;
    pub fn R_calloc_gc(arg1: usize, arg2: usize) -> *mut ::std::os::raw::c_void;
    pub fn R_realloc_gc(
        arg1: *mut ::std::os::raw::c_void,
        arg2: usize,
    ) -> *mut ::std::os::raw::c_void;
    #[doc = "../../main/sort.c :"]
    pub fn R_isort(arg1: *mut ::std::os::raw::c_int, arg2: ::std::os::raw::c_int);
    pub fn R_rsort(arg1: *mut f64, arg2: ::std::os::raw::c_int);
    pub fn R_csort(arg1: *mut Rcomplex, arg2: ::std::os::raw::c_int);
    pub fn rsort_with_index(
        arg1: *mut f64,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
    pub fn Rf_revsort(
        arg1: *mut f64,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
    pub fn Rf_iPsort(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
    pub fn Rf_rPsort(arg1: *mut f64, arg2: ::std::os::raw::c_int, arg3: ::std::os::raw::c_int);
    pub fn Rf_cPsort(arg1: *mut Rcomplex, arg2: ::std::os::raw::c_int, arg3: ::std::os::raw::c_int);
    #[doc = "../../main/qsort.c : */\n/* dummy renamed to II to avoid problems with g++ on Solaris"]
    pub fn R_qsort(v: *mut f64, i: usize, j: usize);
    pub fn R_qsort_I(
        v: *mut f64,
        II: *mut ::std::os::raw::c_int,
        i: ::std::os::raw::c_int,
        j: ::std::os::raw::c_int,
    );
    pub fn R_qsort_int(iv: *mut ::std::os::raw::c_int, i: usize, j: usize);
    pub fn R_qsort_int_I(
        iv: *mut ::std::os::raw::c_int,
        II: *mut ::std::os::raw::c_int,
        i: ::std::os::raw::c_int,
        j: ::std::os::raw::c_int,
    );
    #[doc = "../../main/util.c  and others :"]
    pub fn R_ExpandFileName(arg1: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
    pub fn Rf_setIVector(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
    pub fn Rf_setRVector(arg1: *mut f64, arg2: ::std::os::raw::c_int, arg3: f64);
    pub fn Rf_StringFalse(arg1: *const ::std::os::raw::c_char) -> Rboolean;
    pub fn Rf_StringTrue(arg1: *const ::std::os::raw::c_char) -> Rboolean;
    pub fn Rf_isBlankString(arg1: *const ::std::os::raw::c_char) -> Rboolean;
    #[doc = "These two are guaranteed to use '.' as the decimal point,\nand to accept \"NA\"."]
    pub fn R_atof(str_: *const ::std::os::raw::c_char) -> f64;
    pub fn R_strtod(c: *const ::std::os::raw::c_char, end: *mut *mut ::std::os::raw::c_char)
        -> f64;
    pub fn R_tmpnam(
        prefix: *const ::std::os::raw::c_char,
        tempdir: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
    pub fn R_tmpnam2(
        prefix: *const ::std::os::raw::c_char,
        tempdir: *const ::std::os::raw::c_char,
        fileext: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
    pub fn R_free_tmpnam(name: *mut ::std::os::raw::c_char);
    pub fn R_CheckUserInterrupt();
    pub fn R_CheckStack();
    pub fn R_CheckStack2(arg1: usize);
    #[doc = "../../appl/interv.c: also in Applic.h"]
    pub fn findInterval(
        xt: *mut f64,
        n: ::std::os::raw::c_int,
        x: f64,
        rightmost_closed: Rboolean,
        all_inside: Rboolean,
        ilo: ::std::os::raw::c_int,
        mflag: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
    pub fn findInterval2(
        xt: *mut f64,
        n: ::std::os::raw::c_int,
        x: f64,
        rightmost_closed: Rboolean,
        all_inside: Rboolean,
        left_open: Rboolean,
        ilo: ::std::os::raw::c_int,
        mflag: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
    pub fn find_interv_vec(
        xt: *mut f64,
        n: *mut ::std::os::raw::c_int,
        x: *mut f64,
        nx: *mut ::std::os::raw::c_int,
        rightmost_closed: *mut ::std::os::raw::c_int,
        all_inside: *mut ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
    );
    #[doc = "../../appl/maxcol.c: also in Applic.h"]
    pub fn R_max_col(
        matrix: *mut f64,
        nr: *mut ::std::os::raw::c_int,
        nc: *mut ::std::os::raw::c_int,
        maxes: *mut ::std::os::raw::c_int,
        ties_meth: *mut ::std::os::raw::c_int,
    );
    pub fn Rprintf(arg1: *const ::std::os::raw::c_char, ...);
    pub fn REprintf(arg1: *const ::std::os::raw::c_char, ...);
    pub fn Rvprintf(arg1: *const ::std::os::raw::c_char, arg2: *mut __va_list_tag);
    pub fn REvprintf(arg1: *const ::std::os::raw::c_char, arg2: *mut __va_list_tag);
    pub fn R_registerRoutines(
        info: *mut DllInfo,
        croutines: *const R_CMethodDef,
        callRoutines: *const R_CallMethodDef,
        fortranRoutines: *const R_FortranMethodDef,
        externalRoutines: *const R_ExternalMethodDef,
    ) -> ::std::os::raw::c_int;
    pub fn R_useDynamicSymbols(info: *mut DllInfo, value: Rboolean) -> Rboolean;
    pub fn R_forceSymbols(info: *mut DllInfo, value: Rboolean) -> Rboolean;
    pub fn R_getDllInfo(name: *const ::std::os::raw::c_char) -> *mut DllInfo;
    #[doc = "To be used by applications embedding R to register their symbols\nthat are not related to any dynamic module"]
    pub fn R_getEmbeddingDllInfo() -> *mut DllInfo;
    pub fn R_FindSymbol(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        symbol: *mut R_RegisteredNativeSymbol,
    ) -> DL_FUNC;
    #[doc = "Interface for exporting and importing functions from one package\nfor use from C code in a package.  The registration part probably\nought to be integrated with the other registrations.  The naming of\nthese routines may be less than ideal."]
    pub fn R_RegisterCCallable(
        package: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        fptr: DL_FUNC,
    );
    pub fn R_GetCCallable(
        package: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
    ) -> DL_FUNC;
    pub fn R_CHAR(x: SEXP) -> *const ::std::os::raw::c_char;
    #[doc = "Various tests with macro versions in the internal headers"]
    pub fn Rf_isNull(s: SEXP) -> Rboolean;
    pub fn Rf_isSymbol(s: SEXP) -> Rboolean;
    pub fn Rf_isLogical(s: SEXP) -> Rboolean;
    pub fn Rf_isReal(s: SEXP) -> Rboolean;
    pub fn Rf_isComplex(s: SEXP) -> Rboolean;
    pub fn Rf_isExpression(s: SEXP) -> Rboolean;
    pub fn Rf_isEnvironment(s: SEXP) -> Rboolean;
    pub fn Rf_isString(s: SEXP) -> Rboolean;
    pub fn Rf_isObject(s: SEXP) -> Rboolean;
    #[doc = "General Cons Cell Attributes"]
    pub fn ATTRIB(x: SEXP) -> SEXP;
    pub fn OBJECT(x: SEXP) -> ::std::os::raw::c_int;
    pub fn MARK(x: SEXP) -> ::std::os::raw::c_int;
    pub fn REFCNT(x: SEXP) -> ::std::os::raw::c_int;
    pub fn SET_ATTRIB(x: SEXP, v: SEXP);
    pub fn DUPLICATE_ATTRIB(to: SEXP, from: SEXP);
    pub fn SHALLOW_DUPLICATE_ATTRIB(to: SEXP, from: SEXP);
    pub fn MARK_NOT_MUTABLE(x: SEXP);
    #[doc = "S4 object testing"]
    pub fn IS_S4_OBJECT(x: SEXP) -> ::std::os::raw::c_int;
    #[doc = "Vector Access Functions"]
    pub fn LENGTH(x: SEXP) -> ::std::os::raw::c_int;
    pub fn XLENGTH(x: SEXP) -> R_xlen_t;
    pub fn IS_LONG_VEC(x: SEXP) -> ::std::os::raw::c_int;
    pub fn LOGICAL(x: SEXP) -> *mut ::std::os::raw::c_int;
    pub fn INTEGER(x: SEXP) -> *mut ::std::os::raw::c_int;
    pub fn RAW(x: SEXP) -> *mut Rbyte;
    pub fn REAL(x: SEXP) -> *mut f64;
    pub fn COMPLEX(x: SEXP) -> *mut Rcomplex;
    pub fn LOGICAL_RO(x: SEXP) -> *const ::std::os::raw::c_int;
    pub fn INTEGER_RO(x: SEXP) -> *const ::std::os::raw::c_int;
    pub fn RAW_RO(x: SEXP) -> *const Rbyte;
    pub fn REAL_RO(x: SEXP) -> *const f64;
    pub fn COMPLEX_RO(x: SEXP) -> *const Rcomplex;
    #[doc = "SEXP (STRING_ELT)(SEXP x, R_xlen_t i);"]
    pub fn VECTOR_ELT(x: SEXP, i: R_xlen_t) -> SEXP;
    pub fn SET_STRING_ELT(x: SEXP, i: R_xlen_t, v: SEXP);
    pub fn SET_VECTOR_ELT(x: SEXP, i: R_xlen_t, v: SEXP) -> SEXP;
    pub fn STRING_PTR_RO(x: SEXP) -> *const SEXP;
    pub fn INTEGER_GET_REGION(
        sx: SEXP,
        i: R_xlen_t,
        n: R_xlen_t,
        buf: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t;
    pub fn REAL_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut f64) -> R_xlen_t;
    pub fn LOGICAL_GET_REGION(
        sx: SEXP,
        i: R_xlen_t,
        n: R_xlen_t,
        buf: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t;
    pub fn COMPLEX_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut Rcomplex) -> R_xlen_t;
    pub fn RAW_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut Rbyte) -> R_xlen_t;
    #[doc = "metadata access"]
    pub fn INTEGER_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
    pub fn INTEGER_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
    pub fn REAL_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
    pub fn REAL_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
    pub fn LOGICAL_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
    pub fn LOGICAL_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
    pub fn STRING_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
    pub fn STRING_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
    pub fn TAG(e: SEXP) -> SEXP;
    pub fn CDR(e: SEXP) -> SEXP;
    pub fn CAAR(e: SEXP) -> SEXP;
    pub fn CDAR(e: SEXP) -> SEXP;
    pub fn CADR(e: SEXP) -> SEXP;
    pub fn CDDR(e: SEXP) -> SEXP;
    pub fn CDDDR(e: SEXP) -> SEXP;
    pub fn CADDR(e: SEXP) -> SEXP;
    pub fn CADDDR(e: SEXP) -> SEXP;
    pub fn CAD4R(e: SEXP) -> SEXP;
    pub fn MISSING(x: SEXP) -> ::std::os::raw::c_int;
    pub fn SET_TAG(x: SEXP, y: SEXP);
    pub fn SETCAR(x: SEXP, y: SEXP) -> SEXP;
    pub fn SETCDR(x: SEXP, y: SEXP) -> SEXP;
    pub fn SETCADR(x: SEXP, y: SEXP) -> SEXP;
    pub fn SETCADDR(x: SEXP, y: SEXP) -> SEXP;
    pub fn SETCADDDR(x: SEXP, y: SEXP) -> SEXP;
    pub fn SETCAD4R(e: SEXP, y: SEXP) -> SEXP;
    #[doc = "Closure Access Functions"]
    pub fn FORMALS(x: SEXP) -> SEXP;
    pub fn BODY(x: SEXP) -> SEXP;
    pub fn CLOENV(x: SEXP) -> SEXP;
    pub fn RSTEP(x: SEXP) -> ::std::os::raw::c_int;
    pub fn RTRACE(x: SEXP) -> ::std::os::raw::c_int;
    pub fn SET_RSTEP(x: SEXP, v: ::std::os::raw::c_int);
    pub fn SET_RTRACE(x: SEXP, v: ::std::os::raw::c_int);
    #[doc = "Symbol Access Functions"]
    pub fn PRINTNAME(x: SEXP) -> SEXP;
    pub fn ENCLOS(x: SEXP) -> SEXP;
    #[doc = "External pointer access macros"]
    pub fn EXTPTR_PROT(arg1: SEXP) -> SEXP;
    pub fn EXTPTR_TAG(arg1: SEXP) -> SEXP;
    pub fn EXTPTR_PTR(arg1: SEXP) -> *mut ::std::os::raw::c_void;
    #[doc = "The \"global\" environment"]
    pub static mut R_GlobalEnv: SEXP;
    #[doc = "An empty environment at the root of the\nenvironment tree"]
    pub static mut R_EmptyEnv: SEXP;
    #[doc = "The base environment; formerly R_NilValue"]
    pub static mut R_BaseEnv: SEXP;
    #[doc = "The (fake) namespace for base"]
    pub static mut R_BaseNamespace: SEXP;
    #[doc = "Registry for registered namespaces"]
    pub static mut R_NamespaceRegistry: SEXP;
    #[doc = "Current srcref, for debuggers"]
    pub static mut R_Srcref: SEXP;
    #[doc = "The nil object"]
    pub static mut R_NilValue: SEXP;
    #[doc = "Unbound marker"]
    pub static mut R_UnboundValue: SEXP;
    #[doc = "Missing argument marker"]
    pub static mut R_MissingArg: SEXP;
    #[doc = "To be found in BC interp. state\n(marker)"]
    pub static mut R_InBCInterpreter: SEXP;
    #[doc = "Use current expression (marker)"]
    pub static mut R_CurrentExpression: SEXP;
    #[doc = "Marker for restarted function calls"]
    pub static mut R_RestartToken: SEXP;
    #[doc = "\"as.character\""]
    pub static mut R_AsCharacterSymbol: SEXP;
    #[doc = "\"@\""]
    pub static mut R_AtsignSymbol: SEXP;
    #[doc = "<-- backcompatible version of:"]
    pub static mut R_baseSymbol: SEXP;
    #[doc = "\"base\""]
    pub static mut R_BaseSymbol: SEXP;
    #[doc = "\"{\""]
    pub static mut R_BraceSymbol: SEXP;
    #[doc = "\"\\[\\[\""]
    pub static mut R_Bracket2Symbol: SEXP;
    #[doc = "\"\\[\""]
    pub static mut R_BracketSymbol: SEXP;
    #[doc = "\"class\""]
    pub static mut R_ClassSymbol: SEXP;
    #[doc = "\".Device\""]
    pub static mut R_DeviceSymbol: SEXP;
    #[doc = "\"dimnames\""]
    pub static mut R_DimNamesSymbol: SEXP;
    #[doc = "\"dim\""]
    pub static mut R_DimSymbol: SEXP;
    #[doc = "\"$\""]
    pub static mut R_DollarSymbol: SEXP;
    #[doc = "\"...\""]
    pub static mut R_DotsSymbol: SEXP;
    #[doc = "\"::\""]
    pub static mut R_DoubleColonSymbol: SEXP;
    #[doc = "\"drop\""]
    pub static mut R_DropSymbol: SEXP;
    #[doc = "\"eval\""]
    pub static mut R_EvalSymbol: SEXP;
    #[doc = "\"function\""]
    pub static mut R_FunctionSymbol: SEXP;
    #[doc = "\".Last.value\""]
    pub static mut R_LastvalueSymbol: SEXP;
    #[doc = "\"levels\""]
    pub static mut R_LevelsSymbol: SEXP;
    #[doc = "\"mode\""]
    pub static mut R_ModeSymbol: SEXP;
    #[doc = "\"na.rm\""]
    pub static mut R_NaRmSymbol: SEXP;
    #[doc = "\"name\""]
    pub static mut R_NameSymbol: SEXP;
    #[doc = "\"names\""]
    pub static mut R_NamesSymbol: SEXP;
    #[doc = "\".__NAMESPACE__.\""]
    pub static mut R_NamespaceEnvSymbol: SEXP;
    #[doc = "\"package\""]
    pub static mut R_PackageSymbol: SEXP;
    #[doc = "\"previous\""]
    pub static mut R_PreviousSymbol: SEXP;
    #[doc = "\"quote\""]
    pub static mut R_QuoteSymbol: SEXP;
    #[doc = "\"row.names\""]
    pub static mut R_RowNamesSymbol: SEXP;
    #[doc = "\".Random.seed\""]
    pub static mut R_SeedsSymbol: SEXP;
    #[doc = "\"sort.list\""]
    pub static mut R_SortListSymbol: SEXP;
    #[doc = "\"source\""]
    pub static mut R_SourceSymbol: SEXP;
    #[doc = "\"spec\""]
    pub static mut R_SpecSymbol: SEXP;
    #[doc = "\":::\""]
    pub static mut R_TripleColonSymbol: SEXP;
    #[doc = "\"tsp\""]
    pub static mut R_TspSymbol: SEXP;
    #[doc = "\".defined\""]
    pub static mut R_dot_defined: SEXP;
    #[doc = "\".Method\""]
    pub static mut R_dot_Method: SEXP;
    #[doc = "\".packageName\""]
    pub static mut R_dot_packageName: SEXP;
    #[doc = "\".target\""]
    pub static mut R_dot_target: SEXP;
    #[doc = "\".Generic\""]
    pub static mut R_dot_Generic: SEXP;
    #[doc = "NA_STRING as a CHARSXP"]
    pub static mut R_NaString: SEXP;
    #[doc = "\"\" as a CHARSXP"]
    pub static mut R_BlankString: SEXP;
    #[doc = "\"\" as a STRSXP"]
    pub static mut R_BlankScalarString: SEXP;
    #[doc = "srcref related functions"]
    pub fn R_GetCurrentSrcref(arg1: ::std::os::raw::c_int) -> SEXP;
    pub fn R_GetSrcFilename(arg1: SEXP) -> SEXP;
    #[doc = "Type Coercions of all kinds"]
    pub fn Rf_asChar(arg1: SEXP) -> SEXP;
    pub fn Rf_coerceVector(arg1: SEXP, arg2: SEXPTYPE) -> SEXP;
    pub fn Rf_PairToVectorList(x: SEXP) -> SEXP;
    pub fn Rf_VectorToPairList(x: SEXP) -> SEXP;
    pub fn Rf_asCharacterFactor(x: SEXP) -> SEXP;
    pub fn Rf_asLogical(x: SEXP) -> ::std::os::raw::c_int;
    pub fn Rf_asInteger(x: SEXP) -> ::std::os::raw::c_int;
    pub fn Rf_asReal(x: SEXP) -> f64;
    pub fn Rf_asComplex(x: SEXP) -> Rcomplex;
    #[doc = "Other Internally Used Functions, excluding those which are inline-able"]
    pub fn Rf_acopy_string(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
    pub fn Rf_alloc3DArray(
        arg1: SEXPTYPE,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> SEXP;
    pub fn Rf_allocArray(arg1: SEXPTYPE, arg2: SEXP) -> SEXP;
    pub fn Rf_allocMatrix(
        arg1: SEXPTYPE,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> SEXP;
    pub fn Rf_allocList(arg1: ::std::os::raw::c_int) -> SEXP;
    pub fn Rf_allocS4Object() -> SEXP;
    pub fn Rf_allocSExp(arg1: SEXPTYPE) -> SEXP;
    pub fn Rf_allocVector3(arg1: SEXPTYPE, arg2: R_xlen_t, arg3: *mut R_allocator_t) -> SEXP;
    pub fn Rf_any_duplicated(x: SEXP, from_last: Rboolean) -> R_xlen_t;
    pub fn Rf_any_duplicated3(x: SEXP, incomp: SEXP, from_last: Rboolean) -> R_xlen_t;
    pub fn Rf_applyClosure(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
    pub fn Rf_classgets(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_cons(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_copyMatrix(arg1: SEXP, arg2: SEXP, arg3: Rboolean);
    pub fn Rf_copyListMatrix(arg1: SEXP, arg2: SEXP, arg3: Rboolean);
    pub fn Rf_copyMostAttrib(arg1: SEXP, arg2: SEXP);
    pub fn Rf_copyVector(arg1: SEXP, arg2: SEXP);
    pub fn Rf_defineVar(arg1: SEXP, arg2: SEXP, arg3: SEXP);
    pub fn Rf_dimgets(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_dimnamesgets(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_duplicate(arg1: SEXP) -> SEXP;
    pub fn Rf_shallow_duplicate(arg1: SEXP) -> SEXP;
    pub fn R_duplicate_attr(arg1: SEXP) -> SEXP;
    pub fn Rf_lazy_duplicate(arg1: SEXP) -> SEXP;
    #[doc = "the next really should not be here and is also in Defn.h"]
    pub fn Rf_duplicated(arg1: SEXP, arg2: Rboolean) -> SEXP;
    pub fn Rf_eval(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_findFun(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_findVar(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_findVarInFrame(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn R_existsVarInFrame(arg1: SEXP, arg2: SEXP) -> Rboolean;
    pub fn R_removeVarFromFrame(arg1: SEXP, arg2: SEXP);
    pub fn Rf_getAttrib(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_GetArrayDimnames(arg1: SEXP) -> SEXP;
    pub fn Rf_GetColNames(arg1: SEXP) -> SEXP;
    pub fn Rf_GetMatrixDimnames(
        arg1: SEXP,
        arg2: *mut SEXP,
        arg3: *mut SEXP,
        arg4: *mut *const ::std::os::raw::c_char,
        arg5: *mut *const ::std::os::raw::c_char,
    );
    pub fn Rf_GetOption(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_GetOption1(arg1: SEXP) -> SEXP;
    pub fn Rf_GetOptionDigits() -> ::std::os::raw::c_int;
    pub fn Rf_GetOptionWidth() -> ::std::os::raw::c_int;
    pub fn Rf_GetRowNames(arg1: SEXP) -> SEXP;
    pub fn Rf_install(arg1: *const ::std::os::raw::c_char) -> SEXP;
    pub fn Rf_installChar(arg1: SEXP) -> SEXP;
    pub fn Rf_installNoTrChar(arg1: SEXP) -> SEXP;
    pub fn Rf_installTrChar(arg1: SEXP) -> SEXP;
    pub fn Rf_isOrdered(arg1: SEXP) -> Rboolean;
    pub fn Rf_isUnordered(arg1: SEXP) -> Rboolean;
    pub fn Rf_isUnsorted(arg1: SEXP, arg2: Rboolean) -> Rboolean;
    pub fn Rf_lengthgets(arg1: SEXP, arg2: R_len_t) -> SEXP;
    pub fn Rf_xlengthgets(arg1: SEXP, arg2: R_xlen_t) -> SEXP;
    pub fn R_lsInternal(arg1: SEXP, arg2: Rboolean) -> SEXP;
    pub fn R_lsInternal3(arg1: SEXP, arg2: Rboolean, arg3: Rboolean) -> SEXP;
    pub fn Rf_match(arg1: SEXP, arg2: SEXP, arg3: ::std::os::raw::c_int) -> SEXP;
    pub fn Rf_namesgets(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_mkChar(arg1: *const ::std::os::raw::c_char) -> SEXP;
    pub fn Rf_mkCharLen(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int) -> SEXP;
    pub fn Rf_ncols(arg1: SEXP) -> ::std::os::raw::c_int;
    pub fn Rf_nrows(arg1: SEXP) -> ::std::os::raw::c_int;
    pub fn Rf_nthcdr(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP;
    pub fn R_ParseEvalString(arg1: *const ::std::os::raw::c_char, arg2: SEXP) -> SEXP;
    pub fn Rf_PrintValue(arg1: SEXP);
    pub fn Rf_setAttrib(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
    pub fn Rf_setVar(arg1: SEXP, arg2: SEXP, arg3: SEXP);
    pub fn Rf_str2type(arg1: *const ::std::os::raw::c_char) -> SEXPTYPE;
    pub fn Rf_StringBlank(arg1: SEXP) -> Rboolean;
    pub fn Rf_substitute(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_topenv(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_translateChar(arg1: SEXP) -> *const ::std::os::raw::c_char;
    pub fn Rf_translateCharUTF8(arg1: SEXP) -> *const ::std::os::raw::c_char;
    pub fn Rf_type2char(arg1: SEXPTYPE) -> *const ::std::os::raw::c_char;
    pub fn Rf_type2rstr(arg1: SEXPTYPE) -> SEXP;
    pub fn Rf_type2str(arg1: SEXPTYPE) -> SEXP;
    pub fn Rf_type2str_nowarn(arg1: SEXPTYPE) -> SEXP;
    pub fn Rf_unprotect_ptr(arg1: SEXP);
    pub fn R_tryEval(arg1: SEXP, arg2: SEXP, arg3: *mut ::std::os::raw::c_int) -> SEXP;
    pub fn R_tryEvalSilent(arg1: SEXP, arg2: SEXP, arg3: *mut ::std::os::raw::c_int) -> SEXP;
    pub fn R_GetCurrentEnv() -> SEXP;
    pub fn Rf_asS4(arg1: SEXP, arg2: Rboolean, arg3: ::std::os::raw::c_int) -> SEXP;
    pub fn Rf_S3Class(arg1: SEXP) -> SEXP;
    pub fn Rf_isBasicClass(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
    pub fn Rf_getCharCE(arg1: SEXP) -> cetype_t;
    pub fn Rf_mkCharCE(arg1: *const ::std::os::raw::c_char, arg2: cetype_t) -> SEXP;
    pub fn Rf_mkCharLenCE(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: cetype_t,
    ) -> SEXP;
    pub fn Rf_reEnc(
        x: *const ::std::os::raw::c_char,
        ce_in: cetype_t,
        ce_out: cetype_t,
        subst: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
    #[doc = "Calling a function with arguments evaluated"]
    pub fn R_forceAndCall(e: SEXP, n: ::std::os::raw::c_int, rho: SEXP) -> SEXP;
    #[doc = "External pointer interface"]
    pub fn R_MakeExternalPtr(p: *mut ::std::os::raw::c_void, tag: SEXP, prot: SEXP) -> SEXP;
    pub fn R_ExternalPtrAddr(s: SEXP) -> *mut ::std::os::raw::c_void;
    pub fn R_ExternalPtrTag(s: SEXP) -> SEXP;
    pub fn R_ExternalPtrProtected(s: SEXP) -> SEXP;
    pub fn R_ClearExternalPtr(s: SEXP);
    pub fn R_SetExternalPtrAddr(s: SEXP, p: *mut ::std::os::raw::c_void);
    pub fn R_SetExternalPtrTag(s: SEXP, tag: SEXP);
    pub fn R_SetExternalPtrProtected(s: SEXP, p: SEXP);
    #[doc = "Added in R 3.4.0"]
    pub fn R_MakeExternalPtrFn(p: DL_FUNC, tag: SEXP, prot: SEXP) -> SEXP;
    pub fn R_ExternalPtrAddrFn(s: SEXP) -> DL_FUNC;
    pub fn R_RegisterFinalizer(s: SEXP, fun: SEXP);
    pub fn R_RegisterCFinalizer(s: SEXP, fun: R_CFinalizer_t);
    pub fn R_RegisterFinalizerEx(s: SEXP, fun: SEXP, onexit: Rboolean);
    pub fn R_RegisterCFinalizerEx(s: SEXP, fun: R_CFinalizer_t, onexit: Rboolean);
    pub fn R_RunPendingFinalizers();
    #[doc = "Weak reference interface"]
    pub fn R_MakeWeakRef(key: SEXP, val: SEXP, fin: SEXP, onexit: Rboolean) -> SEXP;
    pub fn R_MakeWeakRefC(key: SEXP, val: SEXP, fin: R_CFinalizer_t, onexit: Rboolean) -> SEXP;
    pub fn R_WeakRefKey(w: SEXP) -> SEXP;
    pub fn R_WeakRefValue(w: SEXP) -> SEXP;
    pub fn R_RunWeakRefFinalizer(w: SEXP);
    pub fn R_ClosureExpr(arg1: SEXP) -> SEXP;
    pub fn R_BytecodeExpr(e: SEXP) -> SEXP;
    #[doc = "Protected evaluation"]
    pub fn R_ToplevelExec(
        fun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        data: *mut ::std::os::raw::c_void,
    ) -> Rboolean;
    pub fn R_ExecWithCleanup(
        fun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP>,
        data: *mut ::std::os::raw::c_void,
        cleanfun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        cleandata: *mut ::std::os::raw::c_void,
    ) -> SEXP;
    pub fn R_tryCatch(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: SEXP,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg5: *mut ::std::os::raw::c_void,
        arg6: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        arg7: *mut ::std::os::raw::c_void,
    ) -> SEXP;
    pub fn R_tryCatchError(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> SEXP;
    pub fn R_withCallingErrorHandler(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> SEXP;
    pub fn R_MakeUnwindCont() -> SEXP;
    pub fn R_ContinueUnwind(cont: SEXP) -> !;
    pub fn R_UnwindProtect(
        fun: ::std::option::Option<unsafe extern "C" fn(data: *mut ::std::os::raw::c_void) -> SEXP>,
        data: *mut ::std::os::raw::c_void,
        cleanfun: ::std::option::Option<
            unsafe extern "C" fn(data: *mut ::std::os::raw::c_void, jump: Rboolean),
        >,
        cleandata: *mut ::std::os::raw::c_void,
        cont: SEXP,
    ) -> SEXP;
    #[doc = "Environment and Binding Features"]
    pub fn R_NewEnv(arg1: SEXP, arg2: ::std::os::raw::c_int, arg3: ::std::os::raw::c_int) -> SEXP;
    pub fn R_IsPackageEnv(rho: SEXP) -> Rboolean;
    pub fn R_PackageEnvName(rho: SEXP) -> SEXP;
    pub fn R_FindPackageEnv(info: SEXP) -> SEXP;
    pub fn R_IsNamespaceEnv(rho: SEXP) -> Rboolean;
    pub fn R_NamespaceEnvSpec(rho: SEXP) -> SEXP;
    pub fn R_FindNamespace(info: SEXP) -> SEXP;
    pub fn R_LockEnvironment(env: SEXP, bindings: Rboolean);
    pub fn R_EnvironmentIsLocked(env: SEXP) -> Rboolean;
    pub fn R_LockBinding(sym: SEXP, env: SEXP);
    pub fn R_unLockBinding(sym: SEXP, env: SEXP);
    pub fn R_MakeActiveBinding(sym: SEXP, fun: SEXP, env: SEXP);
    pub fn R_BindingIsLocked(sym: SEXP, env: SEXP) -> Rboolean;
    pub fn R_BindingIsActive(sym: SEXP, env: SEXP) -> Rboolean;
    pub fn R_ActiveBindingFunction(sym: SEXP, env: SEXP) -> SEXP;
    pub fn R_HasFancyBindings(rho: SEXP) -> Rboolean;
    pub fn Rf_errorcall(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...) -> !;
    pub fn Rf_warningcall(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...);
    pub fn Rf_warningcall_immediate(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...);
    pub fn R_XDREncodeDouble(d: f64, buf: *mut ::std::os::raw::c_void);
    pub fn R_XDRDecodeDouble(buf: *mut ::std::os::raw::c_void) -> f64;
    pub fn R_XDREncodeInteger(i: ::std::os::raw::c_int, buf: *mut ::std::os::raw::c_void);
    pub fn R_XDRDecodeInteger(buf: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
    pub fn R_InitInPStream(
        stream: R_inpstream_t,
        data: R_pstream_data_t,
        type_: R_pstream_format_t,
        inchar: ::std::option::Option<
            unsafe extern "C" fn(arg1: R_inpstream_t) -> ::std::os::raw::c_int,
        >,
        inbytes: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: R_inpstream_t,
                arg2: *mut ::std::os::raw::c_void,
                arg3: ::std::os::raw::c_int,
            ),
        >,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
    pub fn R_InitOutPStream(
        stream: R_outpstream_t,
        data: R_pstream_data_t,
        type_: R_pstream_format_t,
        version: ::std::os::raw::c_int,
        outchar: ::std::option::Option<
            unsafe extern "C" fn(arg1: R_outpstream_t, arg2: ::std::os::raw::c_int),
        >,
        outbytes: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: R_outpstream_t,
                arg2: *mut ::std::os::raw::c_void,
                arg3: ::std::os::raw::c_int,
            ),
        >,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
    pub fn R_InitFileInPStream(
        stream: R_inpstream_t,
        fp: *mut FILE,
        type_: R_pstream_format_t,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
    pub fn R_InitFileOutPStream(
        stream: R_outpstream_t,
        fp: *mut FILE,
        type_: R_pstream_format_t,
        version: ::std::os::raw::c_int,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
    pub fn R_Serialize(s: SEXP, ops: R_outpstream_t);
    pub fn R_Unserialize(ips: R_inpstream_t) -> SEXP;
    pub fn R_SerializeInfo(ips: R_inpstream_t) -> SEXP;
    #[doc = "slot management (in attrib.c)"]
    pub fn R_do_slot(obj: SEXP, name: SEXP) -> SEXP;
    pub fn R_do_slot_assign(obj: SEXP, name: SEXP, value: SEXP) -> SEXP;
    pub fn R_has_slot(obj: SEXP, name: SEXP) -> ::std::os::raw::c_int;
    #[doc = "S3-S4 class (inheritance), attrib.c"]
    pub fn R_S4_extends(klass: SEXP, useTable: SEXP) -> SEXP;
    #[doc = "class definition, new objects (objects.c)"]
    pub fn R_do_MAKE_CLASS(what: *const ::std::os::raw::c_char) -> SEXP;
    pub fn R_getClassDef(what: *const ::std::os::raw::c_char) -> SEXP;
    pub fn R_getClassDef_R(what: SEXP) -> SEXP;
    pub fn R_has_methods_attached() -> Rboolean;
    pub fn R_isVirtualClass(class_def: SEXP, env: SEXP) -> Rboolean;
    pub fn R_extends(class1: SEXP, class2: SEXP, env: SEXP) -> Rboolean;
    pub fn R_do_new_object(class_def: SEXP) -> SEXP;
    #[doc = "supporting  a C-level version of  is(., .) :"]
    pub fn R_check_class_and_super(
        x: SEXP,
        valid: *mut *const ::std::os::raw::c_char,
        rho: SEXP,
    ) -> ::std::os::raw::c_int;
    pub fn R_check_class_etc(
        x: SEXP,
        valid: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
    #[doc = "preserve objects across GCs"]
    pub fn R_PreserveObject(arg1: SEXP);
    pub fn R_ReleaseObject(arg1: SEXP);
    pub fn R_NewPreciousMSet(arg1: ::std::os::raw::c_int) -> SEXP;
    pub fn R_PreserveInMSet(x: SEXP, mset: SEXP);
    pub fn R_ReleaseFromMSet(x: SEXP, mset: SEXP);
    pub fn R_ReleaseMSet(mset: SEXP, keepSize: ::std::os::raw::c_int);
    #[doc = "Shutdown actions"]
    pub fn R_dot_Last();
    pub fn R_RunExitFinalizers();
    pub fn R_system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
    pub fn R_compute_identical(arg1: SEXP, arg2: SEXP, arg3: ::std::os::raw::c_int) -> Rboolean;
    pub fn R_body_no_src(x: SEXP) -> SEXP;
    #[doc = "C version of R's  indx <- order(..., na.last, decreasing) :\ne.g.  arglist = Rf_lang2(x,y)  or  Rf_lang3(x,y,z)"]
    pub fn R_orderVector(
        indx: *mut ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
        arglist: SEXP,
        nalast: Rboolean,
        decreasing: Rboolean,
    );
    #[doc = "C version of R's  indx <- order(x, na.last, decreasing) :"]
    pub fn R_orderVector1(
        indx: *mut ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
        x: SEXP,
        nalast: Rboolean,
        decreasing: Rboolean,
    );
    #[doc = "These are the public inlinable functions that are provided in\nRinlinedfuns.h It is *essential* that these do not appear in any\nother header file, with or without the Rf_ prefix."]
    pub fn Rf_allocVector(arg1: SEXPTYPE, arg2: R_xlen_t) -> SEXP;
    pub fn Rf_conformable(arg1: SEXP, arg2: SEXP) -> Rboolean;
    pub fn Rf_elt(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP;
    pub fn Rf_inherits(arg1: SEXP, arg2: *const ::std::os::raw::c_char) -> Rboolean;
    pub fn Rf_isArray(arg1: SEXP) -> Rboolean;
    pub fn Rf_isFactor(arg1: SEXP) -> Rboolean;
    pub fn Rf_isFrame(arg1: SEXP) -> Rboolean;
    pub fn Rf_isFunction(arg1: SEXP) -> Rboolean;
    pub fn Rf_isInteger(arg1: SEXP) -> Rboolean;
    pub fn Rf_isLanguage(arg1: SEXP) -> Rboolean;
    pub fn Rf_isList(arg1: SEXP) -> Rboolean;
    pub fn Rf_isMatrix(arg1: SEXP) -> Rboolean;
    pub fn Rf_isNewList(arg1: SEXP) -> Rboolean;
    pub fn Rf_isNumber(arg1: SEXP) -> Rboolean;
    pub fn Rf_isNumeric(arg1: SEXP) -> Rboolean;
    pub fn Rf_isPairList(arg1: SEXP) -> Rboolean;
    pub fn Rf_isPrimitive(arg1: SEXP) -> Rboolean;
    pub fn Rf_isTs(arg1: SEXP) -> Rboolean;
    pub fn Rf_isUserBinop(arg1: SEXP) -> Rboolean;
    pub fn Rf_isVector(arg1: SEXP) -> Rboolean;
    pub fn Rf_isVectorAtomic(arg1: SEXP) -> Rboolean;
    pub fn Rf_isVectorList(arg1: SEXP) -> Rboolean;
    pub fn Rf_isVectorizable(arg1: SEXP) -> Rboolean;
    pub fn Rf_lang1(arg1: SEXP) -> SEXP;
    pub fn Rf_lang2(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_lang3(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
    pub fn Rf_lang4(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP;
    pub fn Rf_lang5(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
    pub fn Rf_lang6(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP, arg6: SEXP)
        -> SEXP;
    pub fn Rf_lastElt(arg1: SEXP) -> SEXP;
    pub fn Rf_lcons(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_length(arg1: SEXP) -> R_len_t;
    pub fn Rf_list1(arg1: SEXP) -> SEXP;
    pub fn Rf_list2(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_list3(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
    pub fn Rf_list4(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP;
    pub fn Rf_list5(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
    pub fn Rf_list6(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP, arg6: SEXP)
        -> SEXP;
    pub fn Rf_listAppend(arg1: SEXP, arg2: SEXP) -> SEXP;
    pub fn Rf_mkNamed(arg1: SEXPTYPE, arg2: *mut *const ::std::os::raw::c_char) -> SEXP;
    pub fn Rf_mkString(arg1: *const ::std::os::raw::c_char) -> SEXP;
    pub fn Rf_nlevels(arg1: SEXP) -> ::std::os::raw::c_int;
    pub fn Rf_stringPositionTr(
        arg1: SEXP,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
    pub fn Rf_ScalarComplex(arg1: Rcomplex) -> SEXP;
    pub fn Rf_ScalarInteger(arg1: ::std::os::raw::c_int) -> SEXP;
    pub fn Rf_ScalarLogical(arg1: ::std::os::raw::c_int) -> SEXP;
    pub fn Rf_ScalarRaw(arg1: Rbyte) -> SEXP;
    pub fn Rf_ScalarReal(arg1: f64) -> SEXP;
    pub fn Rf_ScalarString(arg1: SEXP) -> SEXP;
    pub fn Rf_xlength(arg1: SEXP) -> R_xlen_t;
    pub fn LENGTH_EX(
        x: SEXP,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
    pub fn Rf_protect(arg1: SEXP) -> SEXP;
    pub fn Rf_unprotect(arg1: ::std::os::raw::c_int);
    pub fn R_ProtectWithIndex(arg1: SEXP, arg2: *mut PROTECT_INDEX);
    pub fn R_Reprotect(arg1: SEXP, arg2: PROTECT_INDEX);
    pub fn CAR(e: SEXP) -> SEXP;
    pub fn DATAPTR(x: SEXP) -> *mut ::std::os::raw::c_void;
    pub fn DATAPTR_RO(x: SEXP) -> *const ::std::os::raw::c_void;
    pub fn DATAPTR_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_void;
    pub fn LOGICAL_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_int;
    pub fn INTEGER_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_int;
    pub fn REAL_OR_NULL(x: SEXP) -> *const f64;
    pub fn COMPLEX_OR_NULL(x: SEXP) -> *const Rcomplex;
    pub fn RAW_OR_NULL(x: SEXP) -> *const Rbyte;
    pub fn INTEGER_ELT(x: SEXP, i: R_xlen_t) -> ::std::os::raw::c_int;
    pub fn REAL_ELT(x: SEXP, i: R_xlen_t) -> f64;
    pub fn LOGICAL_ELT(x: SEXP, i: R_xlen_t) -> ::std::os::raw::c_int;
    pub fn COMPLEX_ELT(x: SEXP, i: R_xlen_t) -> Rcomplex;
    pub fn RAW_ELT(x: SEXP, i: R_xlen_t) -> Rbyte;
    pub fn STRING_ELT(x: SEXP, i: R_xlen_t) -> SEXP;
    pub fn SET_LOGICAL_ELT(x: SEXP, i: R_xlen_t, v: ::std::os::raw::c_int);
    pub fn SET_INTEGER_ELT(x: SEXP, i: R_xlen_t, v: ::std::os::raw::c_int);
    pub fn SET_REAL_ELT(x: SEXP, i: R_xlen_t, v: f64);
    pub fn SET_COMPLEX_ELT(x: SEXP, i: R_xlen_t, v: Rcomplex);
    pub fn SET_RAW_ELT(x: SEXP, i: R_xlen_t, v: Rbyte);
    #[doc = "ALTREP support"]
    pub fn ALTREP_CLASS(x: SEXP) -> SEXP;
    pub fn R_altrep_data1(x: SEXP) -> SEXP;
    pub fn R_altrep_data2(x: SEXP) -> SEXP;
    pub fn R_set_altrep_data1(x: SEXP, v: SEXP);
    pub fn R_set_altrep_data2(x: SEXP, v: SEXP);
    pub fn LOGICAL0(x: SEXP) -> *mut ::std::os::raw::c_int;
    pub fn INTEGER0(x: SEXP) -> *mut ::std::os::raw::c_int;
    pub fn RAW0(x: SEXP) -> *mut Rbyte;
    pub fn ALTREP(x: SEXP) -> ::std::os::raw::c_int;
    #[doc = "public C interface"]
    pub fn R_asHashtable(h: SEXP) -> R_hashtab_type;
    pub fn R_HashtabSEXP(h: R_hashtab_type) -> SEXP;
    pub fn R_isHashtable(h: SEXP) -> ::std::os::raw::c_int;
    pub fn R_mkhashtab(type_: ::std::os::raw::c_int, arg1: ::std::os::raw::c_int)
        -> R_hashtab_type;
    pub fn R_gethash(h: R_hashtab_type, key: SEXP, nomatch: SEXP) -> SEXP;
    pub fn R_sethash(h: R_hashtab_type, key: SEXP, value: SEXP) -> SEXP;
    pub fn R_remhash(h: R_hashtab_type, key: SEXP) -> ::std::os::raw::c_int;
    pub fn R_numhash(h: R_hashtab_type) -> ::std::os::raw::c_int;
    pub fn R_typhash(h: R_hashtab_type) -> ::std::os::raw::c_int;
    pub fn R_maphash(h: R_hashtab_type, FUN: SEXP) -> SEXP;
    pub fn R_maphashC(
        h: R_hashtab_type,
        FUN: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: *mut ::std::os::raw::c_void),
        >,
        data: *mut ::std::os::raw::c_void,
    );
    pub fn R_clrhash(h: R_hashtab_type);
    pub fn SET_OBJECT(x: SEXP, v: ::std::os::raw::c_int);
    pub fn IS_SCALAR(x: SEXP, type_: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
    pub fn Rf_psmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: Rboolean,
    ) -> Rboolean;
    pub fn R_FlushConsole();
    pub fn Rf_onintr();
    pub fn Rf_onintrNoResume();
    #[doc = "C stack limit"]
    pub static mut R_CStackLimit: usize;
    pub fn R_common_command_line(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: Rstart,
    );
    pub fn setup_Rmainloop();
    pub fn Rf_endEmbeddedR(fatal: ::std::os::raw::c_int);
    pub fn Rf_initialize_R(
        ac: ::std::os::raw::c_int,
        av: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
    pub fn CleanEd();
    pub fn R_CleanTempDir();
    #[doc = "R's versions with !R_FINITE checks"]
    pub fn R_pow(x: f64, y: f64) -> f64;
    pub fn R_pow_di(arg1: f64, arg2: ::std::os::raw::c_int) -> f64;
    #[doc = "Random Number Generators"]
    pub fn norm_rand() -> f64;
    pub fn unif_rand() -> f64;
    pub fn R_unif_index(arg1: f64) -> f64;
    pub fn exp_rand() -> f64;
    pub fn Rf_dnorm4(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pnorm5(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qnorm5(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rnorm(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_pnorm_both(
        arg1: f64,
        arg2: *mut f64,
        arg3: *mut f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    );
    pub fn Rf_dunif(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_punif(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qunif(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_runif(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dgamma(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pgamma(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qgamma(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rgamma(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_log1pmx(arg1: f64) -> f64;
    pub fn Rf_log1pexp(arg1: f64) -> f64;
    pub fn Rf_log1mexp(arg1: f64) -> f64;
    pub fn Rf_lgamma1p(arg1: f64) -> f64;
    pub fn Rf_logspace_add(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_logspace_sub(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_logspace_sum(arg1: *const f64, arg2: ::std::os::raw::c_int) -> f64;
    pub fn Rf_dbeta(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rbeta(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dlnorm(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_plnorm(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qlnorm(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rlnorm(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dchisq(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pchisq(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qchisq(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rchisq(arg1: f64) -> f64;
    pub fn Rf_dnchisq(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pnchisq(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qnchisq(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rnchisq(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_df(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pf(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qf(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rf(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dt(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pt(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qt(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rt(arg1: f64) -> f64;
    pub fn Rf_dbinom_raw(x: f64, n: f64, p: f64, q: f64, give_log: ::std::os::raw::c_int) -> f64;
    pub fn Rf_dbinom(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pbinom(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qbinom(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rbinom(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_rmultinom(
        arg1: ::std::os::raw::c_int,
        arg2: *mut f64,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    );
    pub fn Rf_dcauchy(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pcauchy(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qcauchy(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rcauchy(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dexp(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pexp(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qexp(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rexp(arg1: f64) -> f64;
    pub fn Rf_dgeom(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pgeom(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qgeom(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rgeom(arg1: f64) -> f64;
    pub fn Rf_dhyper(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_phyper(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qhyper(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rhyper(arg1: f64, arg2: f64, arg3: f64) -> f64;
    pub fn Rf_dnbinom(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pnbinom(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qnbinom(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rnbinom(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dnbinom_mu(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pnbinom_mu(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qnbinom_mu(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rnbinom_mu(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dpois_raw(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
    pub fn Rf_dpois(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
    pub fn Rf_ppois(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qpois(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rpois(arg1: f64) -> f64;
    pub fn Rf_dweibull(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pweibull(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qweibull(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rweibull(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dlogis(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_plogis(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qlogis(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rlogis(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_dnbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_pnbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qnbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rnbeta(arg1: f64, arg2: f64, arg3: f64) -> f64;
    pub fn Rf_dnf(arg1: f64, arg2: f64, arg3: f64, arg4: f64, arg5: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pnf(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qnf(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_dnt(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pnt(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qnt(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_ptukey(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qtukey(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_dwilcox(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
    pub fn Rf_pwilcox(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qwilcox(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rwilcox(arg1: f64, arg2: f64) -> f64;
    pub fn wilcox_free();
    pub fn Rf_dsignrank(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
    pub fn Rf_psignrank(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_qsignrank(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
    pub fn Rf_rsignrank(arg1: f64) -> f64;
    pub fn signrank_free();
    pub fn Rf_gammafn(arg1: f64) -> f64;
    pub fn Rf_lgammafn(arg1: f64) -> f64;
    pub fn Rf_lgammafn_sign(arg1: f64, arg2: *mut ::std::os::raw::c_int) -> f64;
    pub fn Rf_dpsifn(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: *mut f64,
        arg6: *mut ::std::os::raw::c_int,
        arg7: *mut ::std::os::raw::c_int,
    );
    pub fn Rf_psigamma(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_digamma(arg1: f64) -> f64;
    pub fn Rf_trigamma(arg1: f64) -> f64;
    pub fn Rf_tetragamma(arg1: f64) -> f64;
    pub fn Rf_pentagamma(arg1: f64) -> f64;
    pub fn Rf_beta(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_lbeta(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_choose(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_lchoose(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_bessel_i(arg1: f64, arg2: f64, arg3: f64) -> f64;
    pub fn Rf_bessel_j(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_bessel_k(arg1: f64, arg2: f64, arg3: f64) -> f64;
    pub fn Rf_bessel_y(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_bessel_i_ex(arg1: f64, arg2: f64, arg3: f64, arg4: *mut f64) -> f64;
    pub fn Rf_bessel_j_ex(arg1: f64, arg2: f64, arg3: *mut f64) -> f64;
    pub fn Rf_bessel_k_ex(arg1: f64, arg2: f64, arg3: f64, arg4: *mut f64) -> f64;
    pub fn Rf_bessel_y_ex(arg1: f64, arg2: f64, arg3: *mut f64) -> f64;
    pub fn Rf_imax2(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
    pub fn Rf_imin2(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
    pub fn Rf_fmax2(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_fmin2(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_sign(arg1: f64) -> f64;
    pub fn Rf_fprec(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_fround(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_fsign(arg1: f64, arg2: f64) -> f64;
    pub fn Rf_ftrunc(arg1: f64) -> f64;
    pub fn cospi(arg1: f64) -> f64;
    pub fn sinpi(arg1: f64) -> f64;
    pub fn tanpi(arg1: f64) -> f64;
    pub fn Rtanpi(arg1: f64) -> f64;
    pub fn R_ParseVector(
        arg1: SEXP,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ParseStatus,
        arg4: SEXP,
    ) -> SEXP;
    pub fn R_new_altrep(aclass: R_altrep_class_t, data1: SEXP, data2: SEXP) -> SEXP;
    pub fn R_make_altstring_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
    pub fn R_make_altinteger_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
    pub fn R_make_altreal_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
    pub fn R_make_altlogical_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
    pub fn R_make_altraw_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
    pub fn R_make_altcomplex_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
    pub fn R_altrep_inherits(x: SEXP, arg1: R_altrep_class_t) -> Rboolean;
    pub fn R_set_altrep_UnserializeEX_method(
        cls: R_altrep_class_t,
        fun: R_altrep_UnserializeEX_method_t,
    );
    pub fn R_set_altrep_Unserialize_method(
        cls: R_altrep_class_t,
        fun: R_altrep_Unserialize_method_t,
    );
    pub fn R_set_altrep_Serialized_state_method(
        cls: R_altrep_class_t,
        fun: R_altrep_Serialized_state_method_t,
    );
    pub fn R_set_altrep_DuplicateEX_method(
        cls: R_altrep_class_t,
        fun: R_altrep_DuplicateEX_method_t,
    );
    pub fn R_set_altrep_Duplicate_method(cls: R_altrep_class_t, fun: R_altrep_Duplicate_method_t);
    pub fn R_set_altrep_Coerce_method(cls: R_altrep_class_t, fun: R_altrep_Coerce_method_t);
    pub fn R_set_altrep_Inspect_method(cls: R_altrep_class_t, fun: R_altrep_Inspect_method_t);
    pub fn R_set_altrep_Length_method(cls: R_altrep_class_t, fun: R_altrep_Length_method_t);
    pub fn R_set_altvec_Dataptr_method(cls: R_altrep_class_t, fun: R_altvec_Dataptr_method_t);
    pub fn R_set_altvec_Dataptr_or_null_method(
        cls: R_altrep_class_t,
        fun: R_altvec_Dataptr_or_null_method_t,
    );
    pub fn R_set_altvec_Extract_subset_method(
        cls: R_altrep_class_t,
        fun: R_altvec_Extract_subset_method_t,
    );
    pub fn R_set_altinteger_Elt_method(cls: R_altrep_class_t, fun: R_altinteger_Elt_method_t);
    pub fn R_set_altinteger_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altinteger_Get_region_method_t,
    );
    pub fn R_set_altinteger_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altinteger_Is_sorted_method_t,
    );
    pub fn R_set_altinteger_No_NA_method(cls: R_altrep_class_t, fun: R_altinteger_No_NA_method_t);
    pub fn R_set_altinteger_Sum_method(cls: R_altrep_class_t, fun: R_altinteger_Sum_method_t);
    pub fn R_set_altinteger_Min_method(cls: R_altrep_class_t, fun: R_altinteger_Min_method_t);
    pub fn R_set_altinteger_Max_method(cls: R_altrep_class_t, fun: R_altinteger_Max_method_t);
    pub fn R_set_altreal_Elt_method(cls: R_altrep_class_t, fun: R_altreal_Elt_method_t);
    pub fn R_set_altreal_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altreal_Get_region_method_t,
    );
    pub fn R_set_altreal_Is_sorted_method(cls: R_altrep_class_t, fun: R_altreal_Is_sorted_method_t);
    pub fn R_set_altreal_No_NA_method(cls: R_altrep_class_t, fun: R_altreal_No_NA_method_t);
    pub fn R_set_altreal_Sum_method(cls: R_altrep_class_t, fun: R_altreal_Sum_method_t);
    pub fn R_set_altreal_Min_method(cls: R_altrep_class_t, fun: R_altreal_Min_method_t);
    pub fn R_set_altreal_Max_method(cls: R_altrep_class_t, fun: R_altreal_Max_method_t);
    pub fn R_set_altlogical_Elt_method(cls: R_altrep_class_t, fun: R_altlogical_Elt_method_t);
    pub fn R_set_altlogical_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altlogical_Get_region_method_t,
    );
    pub fn R_set_altlogical_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altlogical_Is_sorted_method_t,
    );
    pub fn R_set_altlogical_No_NA_method(cls: R_altrep_class_t, fun: R_altlogical_No_NA_method_t);
    pub fn R_set_altlogical_Sum_method(cls: R_altrep_class_t, fun: R_altlogical_Sum_method_t);
    pub fn R_set_altraw_Elt_method(cls: R_altrep_class_t, fun: R_altraw_Elt_method_t);
    pub fn R_set_altraw_Get_region_method(cls: R_altrep_class_t, fun: R_altraw_Get_region_method_t);
    pub fn R_set_altcomplex_Elt_method(cls: R_altrep_class_t, fun: R_altcomplex_Elt_method_t);
    pub fn R_set_altcomplex_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altcomplex_Get_region_method_t,
    );
    pub fn R_set_altstring_Elt_method(cls: R_altrep_class_t, fun: R_altstring_Elt_method_t);
    pub fn R_set_altstring_Set_elt_method(cls: R_altrep_class_t, fun: R_altstring_Set_elt_method_t);
    pub fn R_set_altstring_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altstring_Is_sorted_method_t,
    );
    pub fn R_set_altstring_No_NA_method(cls: R_altrep_class_t, fun: R_altstring_No_NA_method_t);
    pub fn R_GE_getVersion() -> ::std::os::raw::c_int;
    pub fn R_GE_checkVersionOrDie(version: ::std::os::raw::c_int);
    pub fn Rf_ndevNumber(arg1: pDevDesc) -> ::std::os::raw::c_int;
    pub fn Rf_NumDevices() -> ::std::os::raw::c_int;
    #[doc = "Check for an available device slot"]
    pub fn R_CheckDeviceAvailable();
    pub fn R_CheckDeviceAvailableBool() -> Rboolean;
    pub fn Rf_curDevice() -> ::std::os::raw::c_int;
    pub fn Rf_nextDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
    pub fn Rf_prevDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
    pub fn Rf_selectDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
    pub fn Rf_killDevice(arg1: ::std::os::raw::c_int);
    pub fn Rf_NoDevices() -> ::std::os::raw::c_int;
    pub fn Rf_NewFrameConfirm(arg1: pDevDesc);
    pub fn Rf_doMouseEvent(
        dd: pDevDesc,
        event: R_MouseEvent,
        buttons: ::std::os::raw::c_int,
        x: f64,
        y: f64,
    );
    pub fn Rf_doKeybd(dd: pDevDesc, rkey: R_KeyName, keyname: *const ::std::os::raw::c_char);
    pub fn Rf_doIdle(dd: pDevDesc);
    pub fn Rf_doesIdle(dd: pDevDesc) -> Rboolean;
    pub static mut R_interrupts_suspended: Rboolean;
    pub static mut R_interrupts_pending: ::std::os::raw::c_int;
    pub static mut mbcslocale: Rboolean;
    pub fn Rf_AdobeSymbol2utf8(
        out: *mut ::std::os::raw::c_char,
        in_: *const ::std::os::raw::c_char,
        nwork: usize,
        usePUA: Rboolean,
    ) -> *mut ::std::os::raw::c_void;
    pub fn Rf_utf8toAdobeSymbol(
        out: *mut ::std::os::raw::c_char,
        in_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
    pub fn Rf_utf8Toutf8NoPUA(in_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
    pub fn Rf_utf8ToLatin1AdobeSymbol2utf8(
        in_: *const ::std::os::raw::c_char,
        usePUA: Rboolean,
    ) -> *const ::std::os::raw::c_char;
    #[doc = "Translates Unicode point to UTF-8"]
    pub fn Rf_ucstoutf8(s: *mut ::std::os::raw::c_char, c: ::std::os::raw::c_uint) -> usize;
    pub fn Rf_desc2GEDesc(dd: pDevDesc) -> pGEDevDesc;
    pub fn GEdeviceNumber(arg1: pGEDevDesc) -> ::std::os::raw::c_int;
    pub fn GEgetDevice(arg1: ::std::os::raw::c_int) -> pGEDevDesc;
    pub fn GEaddDevice(arg1: pGEDevDesc);
    pub fn GEaddDevice2(arg1: pGEDevDesc, arg2: *const ::std::os::raw::c_char);
    pub fn GEaddDevice2f(
        arg1: pGEDevDesc,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    );
    pub fn GEkillDevice(arg1: pGEDevDesc);
    pub fn GEcreateDevDesc(dev: pDevDesc) -> pGEDevDesc;
    pub fn GEdestroyDevDesc(dd: pGEDevDesc);
    pub fn GEsystemState(
        dd: pGEDevDesc,
        index: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
    pub fn GEregisterWithDevice(dd: pGEDevDesc);
    pub fn GEregisterSystem(callback: GEcallback, systemRegisterIndex: *mut ::std::os::raw::c_int);
    pub fn GEunregisterSystem(registerIndex: ::std::os::raw::c_int);
    pub fn GEhandleEvent(event: GEevent, dev: pDevDesc, data: SEXP) -> SEXP;
    pub fn GEfromDeviceX(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
    pub fn GEtoDeviceX(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
    pub fn GEfromDeviceY(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
    pub fn GEtoDeviceY(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
    pub fn GEfromDeviceWidth(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
    pub fn GEtoDeviceWidth(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
    pub fn GEfromDeviceHeight(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
    pub fn GEtoDeviceHeight(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
    pub fn Rf_RGBpar(arg1: SEXP, arg2: ::std::os::raw::c_int) -> rcolor;
    pub fn Rf_RGBpar3(arg1: SEXP, arg2: ::std::os::raw::c_int, arg3: rcolor) -> rcolor;
    pub fn Rf_col2name(col: rcolor) -> *const ::std::os::raw::c_char;
    #[doc = "Convert either a name or a #RRGGBB\\[AA\\] string to internal.\nBecause people were using it, it also converts \"1\", \"2\" ...\nto a colour in the palette, and \"0\" to transparent white."]
    pub fn R_GE_str2col(s: *const ::std::os::raw::c_char) -> rcolor;
    pub fn GE_LENDpar(value: SEXP, ind: ::std::os::raw::c_int) -> R_GE_lineend;
    pub fn GE_LENDget(lend: R_GE_lineend) -> SEXP;
    pub fn GE_LJOINpar(value: SEXP, ind: ::std::os::raw::c_int) -> R_GE_linejoin;
    pub fn GE_LJOINget(ljoin: R_GE_linejoin) -> SEXP;
    pub fn GESetClip(x1: f64, y1: f64, x2: f64, y2: f64, dd: pGEDevDesc);
    pub fn GENewPage(gc: pGEcontext, dd: pGEDevDesc);
    pub fn GELine(x1: f64, y1: f64, x2: f64, y2: f64, gc: pGEcontext, dd: pGEDevDesc);
    pub fn GEPolyline(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
    pub fn GEPolygon(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
    pub fn GEXspline(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        s: *mut f64,
        open: Rboolean,
        repEnds: Rboolean,
        draw: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> SEXP;
    pub fn GECircle(x: f64, y: f64, radius: f64, gc: pGEcontext, dd: pGEDevDesc);
    pub fn GERect(x0: f64, y0: f64, x1: f64, y1: f64, gc: pGEcontext, dd: pGEDevDesc);
    pub fn GEPath(
        x: *mut f64,
        y: *mut f64,
        npoly: ::std::os::raw::c_int,
        nper: *mut ::std::os::raw::c_int,
        winding: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
    pub fn GERaster(
        raster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        x: f64,
        y: f64,
        width: f64,
        height: f64,
        angle: f64,
        interpolate: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
    pub fn GECap(dd: pGEDevDesc) -> SEXP;
    pub fn GEText(
        x: f64,
        y: f64,
        str_: *const ::std::os::raw::c_char,
        enc: cetype_t,
        xc: f64,
        yc: f64,
        rot: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
    pub fn GEMode(mode: ::std::os::raw::c_int, dd: pGEDevDesc);
    pub fn GESymbol(
        x: f64,
        y: f64,
        pch: ::std::os::raw::c_int,
        size: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
    pub fn GEPretty(lo: *mut f64, up: *mut f64, ndiv: *mut ::std::os::raw::c_int);
    pub fn GEMetricInfo(
        c: ::std::os::raw::c_int,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
    pub fn GEStrWidth(
        str_: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
    pub fn GEStrHeight(
        str_: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
    pub fn GEStrMetric(
        str_: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
    pub fn GEstring_to_pch(pch: SEXP) -> ::std::os::raw::c_int;
    #[doc = "-------------------------------------------------------------------\n\n  LINE TEXTURE CODE is concerned with the internals of R\n  line texture representation."]
    pub fn GE_LTYpar(arg1: SEXP, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_uint;
    pub fn GE_LTYget(arg1: ::std::os::raw::c_uint) -> SEXP;
    #[doc = "Raster operations"]
    pub fn R_GE_rasterScale(
        sraster: *mut ::std::os::raw::c_uint,
        sw: ::std::os::raw::c_int,
        sh: ::std::os::raw::c_int,
        draster: *mut ::std::os::raw::c_uint,
        dw: ::std::os::raw::c_int,
        dh: ::std::os::raw::c_int,
    );
    pub fn R_GE_rasterInterpolate(
        sraster: *mut ::std::os::raw::c_uint,
        sw: ::std::os::raw::c_int,
        sh: ::std::os::raw::c_int,
        draster: *mut ::std::os::raw::c_uint,
        dw: ::std::os::raw::c_int,
        dh: ::std::os::raw::c_int,
    );
    pub fn R_GE_rasterRotatedSize(
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        wnew: *mut ::std::os::raw::c_int,
        hnew: *mut ::std::os::raw::c_int,
    );
    pub fn R_GE_rasterRotatedOffset(
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        botleft: ::std::os::raw::c_int,
        xoff: *mut f64,
        yoff: *mut f64,
    );
    pub fn R_GE_rasterResizeForRotation(
        sraster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        newRaster: *mut ::std::os::raw::c_uint,
        wnew: ::std::os::raw::c_int,
        hnew: ::std::os::raw::c_int,
        gc: pGEcontext,
    );
    pub fn R_GE_rasterRotate(
        sraster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        draster: *mut ::std::os::raw::c_uint,
        gc: pGEcontext,
        perPixelAlpha: Rboolean,
    );
    #[doc = "From plotmath.c"]
    pub fn GEExpressionWidth(expr: SEXP, gc: pGEcontext, dd: pGEDevDesc) -> f64;
    pub fn GEExpressionHeight(expr: SEXP, gc: pGEcontext, dd: pGEDevDesc) -> f64;
    pub fn GEExpressionMetric(
        expr: SEXP,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
    pub fn GEMathText(
        x: f64,
        y: f64,
        expr: SEXP,
        xc: f64,
        yc: f64,
        rot: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
    #[doc = "From plot3d.c : used in package clines"]
    pub fn GEcontourLines(
        x: *mut f64,
        nx: ::std::os::raw::c_int,
        y: *mut f64,
        ny: ::std::os::raw::c_int,
        z: *mut f64,
        levels: *mut f64,
        nl: ::std::os::raw::c_int,
    ) -> SEXP;
    #[doc = "From vfonts.c"]
    pub fn R_GE_VStrWidth(
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
    pub fn R_GE_VStrHeight(
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
    pub fn R_GE_VText(
        x: f64,
        y: f64,
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        x_justify: f64,
        y_justify: f64,
        rotation: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
    pub fn GEcurrentDevice() -> pGEDevDesc;
    pub fn GEdeviceDirty(dd: pGEDevDesc) -> Rboolean;
    pub fn GEdirtyDevice(dd: pGEDevDesc);
    pub fn GEcheckState(dd: pGEDevDesc) -> Rboolean;
    pub fn GErecording(call: SEXP, dd: pGEDevDesc) -> Rboolean;
    pub fn GErecordGraphicOperation(op: SEXP, args: SEXP, dd: pGEDevDesc);
    pub fn GEinitDisplayList(dd: pGEDevDesc);
    pub fn GEplayDisplayList(dd: pGEDevDesc);
    pub fn GEcopyDisplayList(fromDevice: ::std::os::raw::c_int);
    pub fn GEcreateSnapshot(dd: pGEDevDesc) -> SEXP;
    pub fn GEplaySnapshot(snapshot: SEXP, dd: pGEDevDesc);
    pub fn GEonExit();
    pub fn GEnullDevice();
    pub fn Rf_CreateAtVector(
        axp: *mut f64,
        usr: *const f64,
        nint: ::std::os::raw::c_int,
        logflag: Rboolean,
    ) -> SEXP;
    pub fn Rf_GAxisPars(
        min: *mut f64,
        max: *mut f64,
        n: *mut ::std::os::raw::c_int,
        log: Rboolean,
        axis: ::std::os::raw::c_int,
    );
    #[doc = "Patterns - from ../../main/patterns.c"]
    pub fn R_GE_isPattern(x: SEXP) -> Rboolean;
    pub fn R_GE_patternType(pattern: SEXP) -> ::std::os::raw::c_int;
    pub fn R_GE_linearGradientX1(pattern: SEXP) -> f64;
    pub fn R_GE_linearGradientY1(pattern: SEXP) -> f64;
    pub fn R_GE_linearGradientX2(pattern: SEXP) -> f64;
    pub fn R_GE_linearGradientY2(pattern: SEXP) -> f64;
    pub fn R_GE_linearGradientNumStops(pattern: SEXP) -> ::std::os::raw::c_int;
    pub fn R_GE_linearGradientStop(pattern: SEXP, i: ::std::os::raw::c_int) -> f64;
    pub fn R_GE_linearGradientColour(pattern: SEXP, i: ::std::os::raw::c_int) -> rcolor;
    pub fn R_GE_linearGradientExtend(pattern: SEXP) -> ::std::os::raw::c_int;
    pub fn R_GE_radialGradientCX1(pattern: SEXP) -> f64;
    pub fn R_GE_radialGradientCY1(pattern: SEXP) -> f64;
    pub fn R_GE_radialGradientR1(pattern: SEXP) -> f64;
    pub fn R_GE_radialGradientCX2(pattern: SEXP) -> f64;
    pub fn R_GE_radialGradientCY2(pattern: SEXP) -> f64;
    pub fn R_GE_radialGradientR2(pattern: SEXP) -> f64;
    pub fn R_GE_radialGradientNumStops(pattern: SEXP) -> ::std::os::raw::c_int;
    pub fn R_GE_radialGradientStop(pattern: SEXP, i: ::std::os::raw::c_int) -> f64;
    pub fn R_GE_radialGradientColour(pattern: SEXP, i: ::std::os::raw::c_int) -> rcolor;
    pub fn R_GE_radialGradientExtend(pattern: SEXP) -> ::std::os::raw::c_int;
    pub fn R_GE_tilingPatternFunction(pattern: SEXP) -> SEXP;
    pub fn R_GE_tilingPatternX(pattern: SEXP) -> f64;
    pub fn R_GE_tilingPatternY(pattern: SEXP) -> f64;
    pub fn R_GE_tilingPatternWidth(pattern: SEXP) -> f64;
    pub fn R_GE_tilingPatternHeight(pattern: SEXP) -> f64;
    pub fn R_GE_tilingPatternExtend(pattern: SEXP) -> ::std::os::raw::c_int;
    pub fn R_GE_clipPathFillRule(path: SEXP) -> ::std::os::raw::c_int;
    pub fn GEStroke(path: SEXP, gc: pGEcontext, dd: pGEDevDesc);
    pub fn GEFill(path: SEXP, rule: ::std::os::raw::c_int, gc: pGEcontext, dd: pGEDevDesc);
    pub fn GEFillStroke(path: SEXP, rule: ::std::os::raw::c_int, gc: pGEcontext, dd: pGEDevDesc);
    pub fn R_GE_maskType(mask: SEXP) -> ::std::os::raw::c_int;
    #[doc = "S Like Memory Management"]
    pub fn R_chk_calloc(arg1: usize, arg2: usize) -> *mut ::std::os::raw::c_void;
    pub fn R_chk_realloc(
        arg1: *mut ::std::os::raw::c_void,
        arg2: usize,
    ) -> *mut ::std::os::raw::c_void;
    pub fn R_chk_free(arg1: *mut ::std::os::raw::c_void);
    #[doc = "vectorizing function   f(x\\[1:n\\], ...) -> x\\[\\]  {overwriting x\\[\\]}."]
    pub fn Rdqags(
        f: integr_fn,
        ex: *mut ::std::os::raw::c_void,
        a: *mut f64,
        b: *mut f64,
        epsabs: *mut f64,
        epsrel: *mut f64,
        result: *mut f64,
        abserr: *mut f64,
        neval: *mut ::std::os::raw::c_int,
        ier: *mut ::std::os::raw::c_int,
        limit: *mut ::std::os::raw::c_int,
        lenw: *mut ::std::os::raw::c_int,
        last: *mut ::std::os::raw::c_int,
        iwork: *mut ::std::os::raw::c_int,
        work: *mut f64,
    );
    pub fn Rdqagi(
        f: integr_fn,
        ex: *mut ::std::os::raw::c_void,
        bound: *mut f64,
        inf: *mut ::std::os::raw::c_int,
        epsabs: *mut f64,
        epsrel: *mut f64,
        result: *mut f64,
        abserr: *mut f64,
        neval: *mut ::std::os::raw::c_int,
        ier: *mut ::std::os::raw::c_int,
        limit: *mut ::std::os::raw::c_int,
        lenw: *mut ::std::os::raw::c_int,
        last: *mut ::std::os::raw::c_int,
        iwork: *mut ::std::os::raw::c_int,
        work: *mut f64,
    );
    pub fn vmmin(
        n: ::std::os::raw::c_int,
        b: *mut f64,
        Fmin: *mut f64,
        fn_: optimfn,
        gr: optimgr,
        maxit: ::std::os::raw::c_int,
        trace: ::std::os::raw::c_int,
        mask: *mut ::std::os::raw::c_int,
        abstol: f64,
        reltol: f64,
        nREPORT: ::std::os::raw::c_int,
        ex: *mut ::std::os::raw::c_void,
        fncount: *mut ::std::os::raw::c_int,
        grcount: *mut ::std::os::raw::c_int,
        fail: *mut ::std::os::raw::c_int,
    );
    pub fn nmmin(
        n: ::std::os::raw::c_int,
        Bvec: *mut f64,
        X: *mut f64,
        Fmin: *mut f64,
        fn_: optimfn,
        fail: *mut ::std::os::raw::c_int,
        abstol: f64,
        intol: f64,
        ex: *mut ::std::os::raw::c_void,
        alpha: f64,
        bet: f64,
        gamm: f64,
        trace: ::std::os::raw::c_int,
        fncount: *mut ::std::os::raw::c_int,
        maxit: ::std::os::raw::c_int,
    );
    pub fn cgmin(
        n: ::std::os::raw::c_int,
        Bvec: *mut f64,
        X: *mut f64,
        Fmin: *mut f64,
        fn_: optimfn,
        gr: optimgr,
        fail: *mut ::std::os::raw::c_int,
        abstol: f64,
        intol: f64,
        ex: *mut ::std::os::raw::c_void,
        type_: ::std::os::raw::c_int,
        trace: ::std::os::raw::c_int,
        fncount: *mut ::std::os::raw::c_int,
        grcount: *mut ::std::os::raw::c_int,
        maxit: ::std::os::raw::c_int,
    );
    pub fn lbfgsb(
        n: ::std::os::raw::c_int,
        m: ::std::os::raw::c_int,
        x: *mut f64,
        l: *mut f64,
        u: *mut f64,
        nbd: *mut ::std::os::raw::c_int,
        Fmin: *mut f64,
        fn_: optimfn,
        gr: optimgr,
        fail: *mut ::std::os::raw::c_int,
        ex: *mut ::std::os::raw::c_void,
        factr: f64,
        pgtol: f64,
        fncount: *mut ::std::os::raw::c_int,
        grcount: *mut ::std::os::raw::c_int,
        maxit: ::std::os::raw::c_int,
        msg: *mut ::std::os::raw::c_char,
        trace: ::std::os::raw::c_int,
        nREPORT: ::std::os::raw::c_int,
    );
    pub fn samin(
        n: ::std::os::raw::c_int,
        pb: *mut f64,
        yb: *mut f64,
        fn_: optimfn,
        maxit: ::std::os::raw::c_int,
        tmax: ::std::os::raw::c_int,
        ti: f64,
        trace: ::std::os::raw::c_int,
        ex: *mut ::std::os::raw::c_void,
    );
    #[doc = "appl/pretty.c: for use in engine.c and util.c"]
    pub fn R_pretty(
        lo: *mut f64,
        up: *mut f64,
        ndiv: *mut ::std::os::raw::c_int,
        min_n: ::std::os::raw::c_int,
        shrink_sml: f64,
        high_u_fact: *const f64,
        eps_correction: ::std::os::raw::c_int,
        return_bounds: ::std::os::raw::c_int,
    ) -> f64;
    #[doc = "Also used in packages nlme, pcaPP"]
    pub fn optif9(
        nr: ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
        x: *mut f64,
        fcn: fcn_p,
        d1fcn: fcn_p,
        d2fcn: d2fcn_p,
        state: *mut ::std::os::raw::c_void,
        typsiz: *mut f64,
        fscale: f64,
        method: ::std::os::raw::c_int,
        iexp: ::std::os::raw::c_int,
        msg: *mut ::std::os::raw::c_int,
        ndigit: ::std::os::raw::c_int,
        itnlim: ::std::os::raw::c_int,
        iagflg: ::std::os::raw::c_int,
        iahflg: ::std::os::raw::c_int,
        dlt: f64,
        gradtl: f64,
        stepmx: f64,
        steptl: f64,
        xpls: *mut f64,
        fpls: *mut f64,
        gpls: *mut f64,
        itrmcd: *mut ::std::os::raw::c_int,
        a: *mut f64,
        wrk: *mut f64,
        itncnt: *mut ::std::os::raw::c_int,
    );
    pub fn R_sample_kind() -> Sampletype;
    pub fn GetRNGstate();
    pub fn PutRNGstate();
    pub fn user_unif_rand() -> *mut f64;
    pub fn user_unif_init(arg1: Int32);
    pub fn user_unif_nseed() -> *mut ::std::os::raw::c_int;
    pub fn user_unif_seedloc() -> *mut ::std::os::raw::c_int;
    pub fn user_norm_rand() -> *mut f64;
}
