% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locations.R
\name{state_population}
\alias{state_population}
\title{Get annual population for states between 2006 and 2012}
\usage{
state_population(state = "WV", key = "WaPo")
}
\arguments{
\item{state}{Filter the data to county within this state (e.g. 'WV')}

\item{key}{Key needed to make query successful}
}
\description{
Get annual population for states between 2006 and 2012
}
\examples{
\donttest{
library(arcos)

wv <- state_population(state="WV", key="WaPo")

head(wv)
}
}
\seealso{
\url{https://www.washingtonpost.com/graphics/2019/investigations/dea-pain-pill-database/#download-resources}

Other geocoded data: \code{\link{buyer_addresses}},
  \code{\link{county_population}},
  \code{\link{not_pharmacies}}, \code{\link{pharm_cbsa}},
  \code{\link{pharm_counties}}, \code{\link{pharm_latlon}},
  \code{\link{pharm_tracts}},
  \code{\link{reporter_addresses}}
}
\concept{geocoded data}
