test_that("aread downloads files", {
  aoptions('repoDir', NULL, T) 
  aread("pbiecek/graphGallery/600bda83cb840947976bd1ce3a11879d") -> ddl_ggplot
  aread("pbiecek/graphGallery/600bda83cb") -> ddl_ggplot_abrv
  
  expect_is(ddl_ggplot, "gg")
  expect_is(ddl_ggplot, "ggplot")
  expect_output(str(ddl_ggplot), "List of 9")
  expect_equal(ddl_ggplot$labels$x, "Sepal.Length")
  
  expect_is(ddl_ggplot_abrv, "gg")
  expect_is(ddl_ggplot_abrv, "ggplot")
  expect_output(str(ddl_ggplot_abrv), "List of 9")
  expect_equal(ddl_ggplot_abrv$labels$y, "Petal.Length")
  
  
  model <- aread("pbiecek/graphGallery/2a6e492cb6982f230e48cf46023e2e4f")
  expect_is(model, "lm")
  expect_output(str(model), "List of 13")
  expect_equal(names(model$coefficients)[2], "Sepal.Length")
  expect_equal(dim(model$model), c(150, 3))
  
})


test_that("asearch works properly", {
  aoptions('repoDir', NULL, T)
  models <- asearch("pbiecek/graphGallery", patterns = c("class:lm", "coefname:Sepal.Length"))
  
  expect_output(str(models), "List of 2")
  expect_output(str(models[1]), "List of 12")
  expect_output(str(models[2]), "List of 13")
  expect_equal(round(unlist(lapply(models, coef)[[1]]),4), round(c(`(Intercept)` = -7.101443,
                                                                   Sepal.Length = 1.858433),4))
  plots <- asearch("pbiecek/graphGallery", 
                   patterns = c("class:gg",
                                "labelx:Sepal.Length"))
  expect_output(str(plots), "List of 2")
  expect_equal(dim(plots[[1]]$data), c(150, 5))
})


test_that("createEmptyRepo creates repo", {
  createLocalRepo("arepo")
  
  expect_equal(list.files("arepo"), c("backpack.db", "gallery"))
  expect_error(createLocalRepo("arepo2", force = FALSE))
  deleteLocalRepo("arepo", deleteRoot = TRUE)
})


test_that("copying from other repositories and showRepo", {
  repo <- "arepo"
  invisible(createLocalRepo(repoDir = repo))
  copyRemoteRepo( repoTo = repo, md5hashes= "600bda83cb840947976bd1ce3a11879d", 
                  user="pbiecek", repo="graphGallery" )
  expect_is(showLocalRepo(repoDir = repo, method = "tags"), "data.frame")
  expect_equal(dim(showLocalRepo(repoDir = repo, method = "tags")), c(8, 3))
  expect_equal(names(showLocalRepo(repoDir = repo, method = "tags")), c("artifact", "tag", "createdDate"))
  
  summaryRemoteRepo(user="pbiecek", repo="graphGallery") -> graphGallery
  expect_output(str(graphGallery), "List of 5")
  expect_equal(graphGallery$artifactsNumber > 50, TRUE)
  
})


test_that("saveToRepo funcion works with regular parameters", {
  repo <- "aepo"
  invisible(createLocalRepo(repoDir = repo))
  pl <- plot(iris$Sepal.Length, iris$Petal.Length)
  saveToRepo(pl, repoDir = repo) -> hash
  
  expect_equal(hash %in% showLocalRepo(repoDir = repo, "tags")[, "artifact"], TRUE)
  
  deleteLocalRepo("arepo", deleteRoot = TRUE)
})


test_that("loadFromRepo functions works with regular parameters", {
  pl2 <- loadFromRemoteRepo("2a6e492cb", repo="graphGallery", user="pbiecek", 
                            value=TRUE)
  expect_output(str(pl2), "List of 13")
})


test_that("object is properly serialized", {
  model <- aread("pbiecek/graphGallery/2a6e492cb6982f230e48cf46023e2e4f")
  expect_equal(digest::digest(model), "2a6e492cb6982f230e48cf46023e2e4f")
})

test_that("search* functions does search", {
  expect_equal(c("600bda83cb840947976bd1ce3a11879d", "70f4f83dbfef2a8afb2f495208d0a60f") %in%
  searchInRemoteRepo(pattern="class:gg", user="pbiecek", repo="graphGallery"), c(TRUE, TRUE))
  
  expect_equal(c("f9ebb370fa8fed2057be1bb11005f5fb", "6f6623ab33ae7f98bf8f5d7457c112eb") %in%
  searchInRemoteRepo(pattern = list( dateFrom = "2014-09-01", 
                                     dateTo = "2014-09-30" ),
                     user="pbiecek", repo="graphGallery"), c(TRUE, TRUE))
  
  expect_equal(c("600bda83cb840947976bd1ce3a11879d", "70f4f83dbfef2a8afb2f495208d0a60f") %in%
  multiSearchInRemoteRepo(pattern=c("class:gg", "labelx:Sepal.Length"),
                          user="pbiecek", repo="graphGallery"), c(TRUE, TRUE))
})

