% Generated by roxygen2 (4.0.0): do not edit by hand
\name{copyLocalRepo}
\alias{copyGithubRepo}
\alias{copyLocalRepo}
\title{Copy an Existing Repository to Another Repository}
\usage{
copyLocalRepo(repoFrom, repoTo, md5hashes)

copyGithubRepo(repoTo, md5hashes, user, repo, branch = "master",
  repoDirGit = FALSE)
}
\arguments{
  \item{repoFrom}{A character that specifies the directory
  of the Repository from which artifacts will be copied.
  Works only on \code{copyLocalRepo}.}

  \item{repoTo}{A character that specifies the directory of
  the Repository in which artifacts will be copied.}

  \item{md5hashes}{A character or character vector
  containing \code{md5hashes} of artifacts to be copied.}

  \item{repo}{Only if coping a Github repository. A
  character containing a name of a Github repository on
  which the \code{repoFrom}-Repository is archived.}

  \item{user}{Only if coping a Github repository. A
  character containing a name of a Github user on whose
  account the \code{repoFrom} is created.}

  \item{branch}{Only if coping with a Github repository. A
  character containing a name of Github Repository's branch
  on which a \code{repoFrom}-Repository is archived.
  Default \code{branch} is \code{master}.}

  \item{repoDirGit}{Only if working with a Github
  repository. A character containing a name of a directory
  on Github repository on which the Repository is stored.
  If the Repository is stored in main folder on Github
  repository, this should be set to \code{repoDirGit =
  FALSE} as default.}
}
\description{
\code{copyRepo} copies artifact from one \code{Repository}
to another \code{Repository}. It adds new files to exising
\code{gallery} folder in \code{repoTo} \code{Repository}.
\code{copyLocalRepo} copies local \code{Repository}, where
\code{copyGithubRepo} copies Github \code{Repository}.
}
\details{
\code{copyRepo} copies artifact from one \link{Repository}
to another \code{Repository}. Functions
\code{copyLocalRepo} and \code{copyGithubRepo} copy
artifacts from the archivist Repositories stored in a local
folder or on a Github. Both of them take \code{md5hash} as
a parameter, which is a result from \link{saveToRepo}
function. For every artifacts, \code{md5hash} is a unique
string of length 32 that comes out as a result of
\link[digest]{digest} function, which uses a
cryptographical MD5 hash algorithm. For more information
see \link{md5hash}.
}
\examples{
\dontrun{


# creating example Repository - that examples will work

exampleRepoDir <- tempdir()
hashes <- searchInGithubRepo( pattern="name", user="pbiecek", repo="archivist", fixed=FALSE )

createEmptyRepo( exampleRepoDir )

copyGithubRepo( repoTo = exampleRepoDir , md5hashes= hashes, user="pbiecek", repo="archivist" )

# removing an example Repository

deleteRepo( exampleRepoDir )

rm( exampleRepoDir )

# many archivist-like Repositories on one Github repository

dir <- paste0(getwd(), "/ex1")
createEmptyRepo( dir )
copyGithubRepo(repoTo = dir , md5hashes = "ff575c261c949d073b2895b05d1097c3",
              user="MarcinKosinski", repo="Museum",
              branch="master", repoDirGit="ex2")
deleteRepo( dir )

}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
\code{\link{Tags}}; \code{\link{archivist-package}};
\code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
\code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
\code{\link{loadFromGithubRepo}},
\code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
\code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
\code{\link{searchInGithubRepo}},
\code{\link{searchInLocalRepo}};
\code{\link{showGithubRepo}}, \code{\link{showLocalRepo}};
\code{\link{summaryGithubRepo}},
\code{\link{summaryLocalRepo}};
\code{\link{tarGithubRepo}}, \code{\link{tarLocalRepo}}
}

