% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/push_pull_Repo.R
\name{pushGitHubRepo}
\alias{pushGitHubRepo}
\alias{pullGithubRepo}
\alias{pullGitHubRepo}
\title{Push and Pull for Repository}
\usage{
pushGitHubRepo(repoDir = aoptions("repoDir"),
  commitMessage = aoptions("commitMessage"), repo = aoptions("repo"),
  user = aoptions("user"), password = aoptions("password"),
  files = c("gallery", "backpack.db"), ...)

pullGitHubRepo(repoDir = aoptions("repoDir"), user = aoptions("user"),
  password = aoptions("password"), ...)
}
\arguments{
\item{repoDir}{A character specifing the directory to Local \code{Repository} to/from which artifacts will be pulled/pushed to GitHub.}

\item{commitMessage}{A character denoting a message added to the commit while performing push.
By default specified to \code{NULL} which corresponds to commit message \code{archivist: pushGitHubRepo}.}

\item{repo}{A character denoting GitHub repository name and synchronized local existing directory in which an artifact will be saved.}

\item{user}{A character denoting GitHub user name. Can be set globally with \code{aoptions("user", user)}.
See \link{archivist-github-integration}.}

\item{password}{A character denoting GitHub user password. Can be set globally with \code{aoptions("password", password)}.
See \link{archivist-github-integration}.}

\item{files}{A character vector containing directories to files that should be commited and pushed. The working directory
is \code{repoDir}. By default all uncommited artifacts and \code{backpack.db} will be pushed.}

\item{...}{Further arguments passed to \link[git2r]{push} or \link[git2r]{pull}.}
}
\description{
\code{pushGitHubRepo} adds files, commits them and pushes from Local \link{Repository} to synchronized GitHub one. 
\code{pullGitHubRepo} pulls (\code{git pull}) changes from remote GitHub \code{Repository} to the correspoding Local one.

This function is well explained on this \href{http://r-bloggers.com/r-hero-saves-backup-city-with-archivist-and-github}{http://r-bloggers.com/r-hero-saves-backup-city-with-archivist-and-github} blog post.
}
\details{
To learn more about  \code{Archivist Integration With GitHub} visit \link{agithub}.
To check the \code{status} (\code{git status}) of the Repository use \code{git2r::status(repository(repoDir))}. See examples.
}
\note{
Bug reports and feature requests can be sent to \href{https://github.com/MarcinKosinski/archivist.github/issues}{https://github.com/MarcinKosinski/archivist.github/issues}
}
\examples{
\dontrun{

authoriseGitHub(ClientID, ClientSecret) -> github_token
# authoriseGitHub also does: aoptions("github_token", github_token)
aoptions("user", user.name)
aoptions("password", user.password)

createGitHubRepo("Museum", default = TRUE) # here github_token is used
data(iris)
saveToLocalRepo(iris)
git2r::status(repository('Museum'))
pushGitHubRepo(commitMessage = "add iris")
git2r::status(repository('Museum'))

}
}
\references{
More about \pkg{archivist.github} can be found on 
\href{http://marcinkosinski.github.io/archivist.github/}{marcinkosinski.github.io/archivist.github/} 
and about \pkg{archivist} in posts' history on \href{https://pbiecek.github.io/archivist/articles/posts.html}{https://pbiecek.github.io/archivist/articles/posts.html}
}
\seealso{
Other archivist.github: \code{\link{archive}},
  \code{\link{archivist.github-package}},
  \code{\link{authoriseGitHub}},
  \code{\link{cloneGitHubRepo}},
  \code{\link{createGitHubRepo}},
  \code{\link{deleteGitHubRepo}}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
