% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compact}
\alias{compact}
\alias{\%||\%}
\title{General utility functions}
\usage{
compact(.x)

a \%||\% b
}
\arguments{
\item{.x}{a list}

\item{a}{an R object}

\item{b}{an R object}
}
\value{
\itemize{
\item \code{compact()} a list
\item \verb{\%||\%} the first non-null item or \code{NULL} if both are \code{NULL}
}
}
\description{
General utility functions
}
\details{
\itemize{
\item \code{compact()} removes any \code{NULL} list elements
\item \verb{\%||\%} is a special pipe operator that returns \code{b} if \code{a} is \code{NULL}
}
}
\examples{

# remove null elements
compact(list(a = NULL, b = 1))

# if NULL return rhs
NULL \%||\% 123

# if not NULL return lhs
123 \%||\% NULL

}
