% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkHzDepthLogic.R
\name{checkHzDepthLogic}
\alias{checkHzDepthLogic}
\title{Check a SoilProfileCollection object for errors in horizon depths.}
\usage{
checkHzDepthLogic(
  x,
  hzdepths = NULL,
  idname = NULL,
  fast = FALSE,
  byhz = FALSE
)
}
\arguments{
\item{x}{\code{SoilProfileCollection} or \code{data.frame} object to check}

\item{hzdepths}{SoilProfileCollection uses \code{horizonDepths(x)} Default: \code{NULL}; if \code{x} is a data.frame, character vector of column names of top and bottom depths}

\item{idname}{SoilProfileCollection uses \code{idname(x)} Default: \code{NULL}; if \code{x} is a data.frame, character vector with column name of unique profile ID;}

\item{fast}{If details about specific test results are not needed, the operation can allocate less memory and run approximately 5x faster. Default: \code{FALSE}}

\item{byhz}{Apply logic tests to profiles or individual horizons?}
}
\value{
A \code{data.frame} containing profile IDs, validity boolean (\code{valid}) and test results if \code{fast = FALSE}.

The \code{data.frame} will have as many rows as profiles in \code{x} (\code{length(x)}).
\itemize{
\item \code{id} : Profile IDs, named according to \code{idname(x)}
\item \code{valid} : boolean, profile passes all of the following tests
\itemize{
\item \code{depthLogic} : boolean, errors related to depth logic
\item \code{sameDepth} : boolean, errors related to same top/bottom depths
\item \code{missingDepth} : boolean, NA in top / bottom depths
\item \code{overlapOrGap} : boolean, gaps or overlap in adjacent horizons
}
}
}
\description{
This function inspects a SoilProfileCollection object, looking for four common errors in horizon depths:
\enumerate{
\item bottom depth shallower than top depth
\item equal top and bottom depth
\item missing top or bottom depth (e.g. \code{NA})
\item gap or overlap between adjacent horizons
}
}
\examples{

## sample data

data(sp3)
depths(sp3) <- id ~ top + bottom

# these data should be clean
res <- checkHzDepthLogic(sp3)

head(res)

# less memory if only concerned about net validity
res <- checkHzDepthLogic(sp3, fast = TRUE)

head(res)

}
\author{
D.E. Beaudette, A.G. Brown, S.M. Roecker
}
