% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wget_apsimx_json.R
\name{get_apsimx_json}
\alias{get_apsimx_json}
\title{fetches the json file for a specific model from APSIMX github}
\usage{
get_apsimx_json(model = "Wheat", wrt.dir = ".", cleanup = FALSE)
}
\arguments{
\item{model}{a model (e.g. \sQuote{Wheat} or \sQuote{Maize})}

\item{wrt.dir}{directory to save the JSON file (default is the current directory)}

\item{cleanup}{whether to delete the JSON file}
}
\value{
a list read through the jsonlite package
}
\description{
Retreives the json replacement file for a specific model
}
\details{
Get APSIM-X Model Replacement from github
}
\examples{
\donttest{
tmp.dir <- tempdir()
wheat <- get_apsimx_json(model = "Wheat", wrt.dir = tmp.dir)
}

}
\seealso{
\code{\link{insert_replacement_node}}
}
