% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_searchStart.R
\name{apollo_searchStart}
\alias{apollo_searchStart}
\title{Searches for better starting values.}
\usage{
apollo_searchStart(apollo_beta, apollo_fixed, apollo_probabilities,
  apollo_inputs, searchStart_settings = NA)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters.
  \item apollo_inputs: List containing options of the model. See \link{apollo_validateInputs}.
  \item functionality: Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{searchStart_settings}{List containing options for the search of starting values. The following are valid options.
\describe{
  \item{nCandidates}{Numeric scalar. Number of candidate sets of parameters to be used at the start. Should be an integer bigger than 1. Default is 100.}
  \item{smartStart}{Boolean. If TRUE, candidates are randomly generated with more chances in the directions the Hessian indicates improvement of the LL function. Default is FALSE.}
  \item{apolloBetaMin}{Vector. Minimum possible value of parameters when generating candidates. Ignored if smartStart is TRUE. Default is \code{apollo_beta - 0.1}.}
  \item{apolloBetaMax}{Vector. Maximum possible value of parameters when generating candidates. Ignored if smartStart is TRUE. Default is \code{apollo_beta + 0.1}.}
  \item{maxStages}{Numeric scalar. Maximum number of search stages. The algorithm will stop when there is only one candidate left, or if it reaches this number of stages. Default is 5.}
  \item{dTest}{Numeric scalar. Tolerance for test 1. A candidate is discarded if its distance in parameter space to a better one is smaller than \code{dTest}. Default is 1.}
  \item{gTest}{Numeric scalar. Tolerance for test 2. A candidate is discarded if the norm of its gradient is smaller than \code{gTest} AND its LL is further than \code{llTest} from a better candidate. Default is 10^(-3).}
  \item{llTest}{Numeric scalar. Tolerance for test 2. A candidate is discarded if the norm of its gradient is smaller than \code{gTest} AND its LL is further than \code{llTest} from a better candidate. Default is 3.}
  \item{bfgsIter}{Numeric scalar. Number od BFGS iterations to perform at each stage to each remaining candidate. Default is 20.}
}}
}
\value{
named vector of model parameters. These are the best values found.
}
\description{
Given a set of starting values and a range for them, searches for points with a better likelihood.
}
\details{
This function implements a simplified version of the algorithm proposed by Bierlaire, Themans, & Zufferey (2010). The main difference
lies in it implementing only two out of three tests on the candidates described by the authors. The implemented algorithm has the
following steps.
\enumerate{
  \item Randomly draw nCandidates candidates from an interval given by the user.
  \item Label all candidates with a valid log-likelihood (LL) as active.
  \item Apply \code{bfgsIter} iterations of the BFGS algorithm to each active candidate.
  \item Apply the following tests to each active candidate:
  \enumerate{
    \item Has the BGFS search converged?
    \item Are the candidate parameters after BFGS closer than \code{dTest} from any other candidate with higher LL?
    \item Is the LL of the candidate after BFGS further than \code{distLL} from a candidate with better LL, and its gradient smaller than \code{gTest}?
  }
  \item Mark any candidates for which at least one test results in yes as inactive.
  \item Go back to step 3, unless only one candidate is active, or the maximum number of iterations (\code{maxStages}) has been reached.
}
}
