% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_perc_api2lm.R
\name{format_perc_api2lm}
\alias{format_perc_api2lm}
\title{Format percentages}
\usage{
format_perc_api2lm(probs, digits)
}
\arguments{
\item{probs}{A vector of probabilities.}

\item{digits}{a positive integer indicating how many significant digits
    are to be used for
    numeric and complex \code{x}.  The default, \code{NULL}, uses
    \code{\link[base]{getOption}("digits")}.  This is a suggestion: enough decimal
    places will be used so that the smallest (in magnitude) number has
    this many significant digits, and also to satisfy \code{nsmall}.
    (For more, notably the interpretation for complex numbers see
    \code{\link[base]{signif}}.)}
}
\value{
A vector of percentages
}
\description{
A recreation of the \code{stats:::format.prec} function that is only available internally to the \code{stats} package.
}
\examples{
format_perc_api2lm(c(0.523423, 0.9098192, 0.951289), digits = 1)
format_perc_api2lm(c(0.523423, 0.9098192, 0.951289), digits = 3)
}
\seealso{
\code{\link[base]{format}}
}
\keyword{internal}
