% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglike.R
\name{LogLike}
\alias{LogLike}
\title{Likelihood of an observed annotated phylogenetic tree}
\usage{
LogLike(tree, psi, mu_d, mu_s, eta, Pi, verb_ans = TRUE, check_dims = TRUE)
}
\arguments{
\item{tree}{A phylogenetic tree of class \link{aphylo}.}

\item{psi}{Numeric vector of length 2. Misclasification probabilities. (see \code{\link{LogLike}}).}

\item{mu_d, mu_s}{Numeric vector of length 2. Gain/loss probabilities (see \code{\link{LogLike}}).}

\item{eta}{Numeric vector of length 2. Annotation bias probabilities (see \code{\link{LogLike}}).}

\item{Pi}{Numeric scalar. Root node probability of having the function (see \code{\link{LogLike}}).}

\item{verb_ans}{Logical scalar. When \code{FALSE} (default) the function
returns a list with a single scalar (the log-likelihood).}

\item{check_dims}{Logical scalar. When \code{TRUE} (default) the function
checks the dimmension of the passed parameters.}
}
\value{
A list of class \code{phylo_LogLik} with the following elements:
\item{S}{An integer matrix of size \eqn{2^p\times p}{2^p * p} as returned
by \code{\link{states}}.}
\item{Pr}{A numeric matrix of size \eqn{G\times 2^p}{G * 2^p} with node/state
probabilities.}
\item{ll}{A numeric scalar with the log-likelihood value given the chosen
parameters.}
}
\description{
This function computes the log-likelihood of the chosen parameters given
a particular dataset. The arguments \code{annotations}, and \code{offspring}
should be as those returned by \code{\link[=new_aphylo]{new_aphylo()}}.
For complete parameter estimation see \link{aphylo_estimates}.
}
\details{
The parameters to estimate are described as follows:
\enumerate{
\item{\code{psi}: A vector of length 2 with \eqn{\psi_0}{psi[0]} and
\eqn{\psi_1}{psi[1]}, which are the misclassification probabilities fo
\eqn{s_p=0}{s[p]=0} and \eqn{s_p=1}{s[p]=1}
respectively.}
\item{\code{mu_d}, \code{mu_s}: A vector of length 2 with \eqn{\mu_0}{mu[0]} and
\eqn{\mu_1}{mu[1]} which are the gain and loss probabilities respectively.
The subscript d denotes duplication nodes and s speciation node.}
\item{\code{eta}: A vector of length 2 with \eqn{\eta_0}{eta[0]} and
\eqn{\eta_1}{eta[1]} which are the annotation bias probabilities.}
\item{\code{Pi}: A numeric scalar which for which equals the probability
of the root node having the function.}
}
}
