% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{raphylo}
\alias{raphylo}
\alias{rmultiAphylo}
\title{Simulation of Annotated Phylogenetic Trees}
\usage{
raphylo(
  n = NULL,
  tree = NULL,
  edge.length = NULL,
  tip.type = NULL,
  node.type = function(n) sample.int(2, size = n, replace = TRUE, prob = c(0.2, 0.8)) -
    1,
  P = 1L,
  psi = c(0.05, 0.05),
  mu_d = c(0.9, 0.5),
  mu_s = c(0.05, 0.02),
  eta = c(1, 1),
  Pi = 0.2,
  informative = getOption("aphylo_informative", FALSE),
  maxtries = 20L
)

rmultiAphylo(R, ...)
}
\arguments{
\item{n}{Integer scalar. Number of leafs. If not specified, then}

\item{tree}{An object of class \link[ape:read.tree]{phylo}.}

\item{edge.length}{Passed to \link{sim_tree}.}

\item{tip.type, node.type}{Integer vectors with values {0,1}. 0 denotes duplication node and 1 speciation node. This is used in \link{LogLike}.}

\item{P}{Integer scalar. Number of functions to generate.}

\item{psi}{Numeric vector of length 2. Misclasification probabilities. (see \code{\link{LogLike}}).}

\item{mu_d, mu_s}{Numeric vector of length 2. Gain/loss probabilities (see \code{\link{LogLike}}).}

\item{eta}{Numeric vector of length 2. Annotation bias probabilities (see \code{\link{LogLike}}).}

\item{Pi}{Numeric scalar. Root node probability of having the function (see \code{\link{LogLike}}).}

\item{informative, maxtries}{Passed to \link{sim_fun_on_tree}.}

\item{R}{Integer, number of replicates}

\item{...}{Further arguments passed to \code{raphylo}}
}
\value{
An object of class \link{aphylo}
}
\description{
Simulation of Annotated Phylogenetic Trees

\code{}
}
\details{
The \code{rmultiAphylo} function is a wrapper around \code{raphylo}.
}
\examples{
# A simple example ----------------------------------------------------------

set.seed(1231)
ans <- raphylo(n=500)

}
\concept{Simulation Functions}
