% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readfiles.R
\name{read.multidna}
\alias{read.multidna}
\alias{read.multiFASTA}
\alias{read.multiphyDat}
\title{Read multiple DNA alignments}
\usage{
read.multidna(files, add.gaps = TRUE, ...)

read.multiFASTA(files, add.gaps = TRUE)

read.multiphyDat(files, add.gaps = TRUE, ...)
}
\arguments{
\item{files}{a vector of characters indicating the paths to the files to read from.}

\item{add.gaps}{a logical indicating if gap-only sequences should be added wherever sequences are missing; defaults to TRUE.}

\item{...}{further arguments to be passed to the functions \code{\link[ape]{read.dna}} and \code{\link[ape]{read.FASTA}}.}
}
\description{
These functions read multiple DNA alignments and store the output in a \linkS4class{multidna} object.
They are relying on ape's original functions \code{\link[ape]{read.dna}} and \code{\link[ape]{read.FASTA}}.
}
\examples{
## get path to the files
files <- dir(system.file(package="apex"),patter="patr", full=TRUE)
files

## read files
x <- read.multiFASTA(files)
x
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2))
plot(x, row=FALSE)
par(opar)

y <- read.multiphyDat(files, format="fasta")
y

}
\seealso{
\itemize{
\item \code{\link[ape]{read.dna}}
\item  \code{\link[ape]{read.FASTA}}
\item \code{\link[phangorn]{read.phyDat}}
}
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}

Klaus Schliep \email{klaus.schliep@gmail.com}
}
