% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot,multidna,ANY-method}
\alias{plot,multidna,ANY-method}
\alias{plot,multidna-method}
\alias{plot.multidna}
\title{Display multidna objects}
\usage{
\S4method{plot}{multidna,ANY}(x, y, rows = TRUE, ask = FALSE, ...)
}
\arguments{
\item{x}{a multidna object}

\item{y}{an integer vector indicating the genes to plot}

\item{rows}{a logical indicating if different genes should be displayed in separate rows}

\item{ask}{a logical indicating if the user should be prompted between graphs}

\item{...}{arguments passed to \code{\link{image.DNAbin}}}
}
\description{
Default printing for multidna objects
}
\examples{
## simple conversion with nicely ordered output
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
x
plot(x)

}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}

Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
