% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_read_shapefile}
\alias{spark_read_shapefile}
\alias{spark_read_geojson}
\alias{spark_read_geoparquet}
\title{Read geospatial data into a Spark DataFrame.}
\usage{
spark_read_shapefile(sc, name = NULL, path = name, options = list(), ...)

spark_read_geojson(
  sc,
  name = NULL,
  path = name,
  options = list(),
  repartition = 0,
  memory = TRUE,
  overwrite = TRUE
)

spark_read_geoparquet(
  sc,
  name = NULL,
  path = name,
  options = list(),
  repartition = 0,
  memory = TRUE,
  overwrite = TRUE
)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{name}{The name to assign to the newly generated table.}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{options}{A list of strings with additional options.
See \url{https://spark.apache.org/docs/latest/sql-programming-guide.html#configuration}.}

\item{...}{Optional arguments; currently unused.}

\item{repartition}{The number of partitions used to distribute the
generated table. Use 0 (the default) to avoid partitioning.}

\item{memory}{Boolean; should the data be loaded eagerly into memory? (That
is, should the table be cached?)}

\item{overwrite}{Boolean; overwrite the table with the given name if it
already exists?}
}
\value{
A tbl
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

These functions are deprecated and will be removed in a future release. Sedona has
been implementing readers as spark DataFrame sources, so you can use \code{spark_read_source}
with the right sources ("shapefile", "geojson", "geoparquet") to read geospatial data.

Functions to read geospatial data from a variety of formats into Spark DataFrames.
\itemize{
\item \code{spark_read_shapefile}: from a shapefile
\item \code{spark_read_geojson}: from a geojson file
\item \code{spark_read_geoparquet}: from a geoparquet file
}
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- spark_read_shapefile(sc, location = input_location)
}

}
\seealso{
Other Sedona DF data interface functions: 
\code{\link{spark_write_geojson}()}
}
\concept{Sedona DF data interface functions}
