% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_rdd.R
\name{approx_count}
\alias{approx_count}
\title{Find the approximate total number of records within a Spatial RDD.}
\usage{
approx_count(x)
}
\arguments{
\item{x}{A Sedona spatial RDD.}
}
\value{
Approximate number of records within the SpatialRDD.
}
\description{
Given a Sedona spatial RDD, find the (possibly approximated) number of total
records within it.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_shapefile_to_typed_rdd(
    sc,
    location = input_location, type = "polygon"
  )
  approx_cnt <- approx_count(rdd)
}

}
\seealso{
Other Spatial RDD aggregation routine: 
\code{\link{minimum_bounding_box}()}
}
\concept{Spatial RDD aggregation routine}
