% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/apaANOVATable1way.R
\name{apa.1way.table}
\alias{apa.1way.table}
\title{Creates a table of means and standard deviations for a 1-way ANOVA design in APA style}
\usage{
apa.1way.table(iv, dv, data, filename = NA, table.number = NA,
  show.conf.interval = FALSE, landscape = FALSE)
}
\arguments{
\item{iv}{Name of independent variable column in data frame}

\item{dv}{Name of dependent variable column in data frame}

\item{data}{Project data frame name}

\item{filename}{(optional) Output filename document filename (must end in .rtf or .doc only)}

\item{table.number}{Integer to use in table number output line}

\item{show.conf.interval}{(TRUE/FALSE) Display confidence intervals in table.}

\item{landscape}{(TRUE/FALSE) Make RTF file landscape}
}
\value{
APA table object
}
\description{
Creates a table of means and standard deviations for a 1-way ANOVA design in APA style
}
\examples{
# View top few rows of viagra data set
# from Discovering Statistics Using R
head(viagra)

# Use apa.1way.table function
apa.1way.table(iv=dose,dv=libido,data=viagra,filename="ex1wayTable.doc")
}

