% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_scale_cph.R
\name{orsf_scale_cph}
\alias{orsf_scale_cph}
\alias{orsf_unscale_cph}
\title{Scale input data}
\usage{
orsf_scale_cph(x_mat, w_vec = NULL)

orsf_unscale_cph(x_mat)
}
\arguments{
\item{x_mat}{(\emph{numeric matrix}) a matrix with values to be scaled or
unscaled. Note that \code{orsf_unscale_cph} will only accept \code{x_mat} inputs
that have an attribute containing transform values, which are added
automatically by \code{orsf_scale_cph}.}

\item{w_vec}{(\emph{numeric vector}) an optional vector of weights. If no weights
are supplied (the default), all observations will be equally weighted. If
supplied, \code{w_vec} must have length equal to \code{nrow(x_mat)}.}
}
\value{
the scaled or unscaled \code{x_mat}.
}
\description{
These functions are exported so that users may access internal routines
that are used to scale inputs when \link{orsf_control_cph} is used.
}
\details{
The data are transformed by first subtracting the mean and then
multiplying by the scale. An inverse transform can be completed using
\code{orsf_unscale_cph} or by dividing each column by the corresponding scale
and then adding the mean.

The values of means and scales are stored in an attribute of the output
returned by \code{orsf_scale_cph} (see examples)
}
\examples{

x_mat <- as.matrix(pbc_orsf[, c('bili', 'age', 'protime')])

head(x_mat)

x_scaled <- orsf_scale_cph(x_mat)

head(x_scaled)

attributes(x_scaled) # note the transforms attribute

x_unscaled <- orsf_unscale_cph(x_scaled)

head(x_unscaled)

# numeric difference in x_mat and x_unscaled should be practically 0
max(abs(x_mat - x_unscaled))
}
