% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Private.R
\docType{class}
\name{Private-class}
\alias{$,Private-method}
\alias{$<-,Private-method}
\alias{Private-class}
\alias{[[,Private-method}
\alias{[[<-,Private-method}
\title{Private class}
\usage{
\S4method{$}{Private}(x, name)

\S4method{$}{Private}(x, name) <- value

\S4method{[[}{Private}(x, i, j, ...)

\S4method{[[}{Private}(x, i, j, ...) <- value
}
\arguments{
\item{x}{the object}

\item{name}{name of field or method}

\item{value}{any object}

\item{i}{like name}

\item{j}{ignored}

\item{...}{ignored}
}
\description{
This is a virtual class to be contained in other class definitions. It overrides the default subset functions \code{$} and \code{[[} such that private member of a class can not be accessed. Private is every object which has a name with a leading "." (\code{grepl("^\\\\.", name)}). After this check the standard method for class 'envRefClass' is called or an error is reported.
}
\examples{
ClassWithPrivateField <- Class({
  Class <- "ClassWithPrivateField"
  contains <- "Private"

  .p <- "numeric"

  getP <- function() .p
  setP <- function(v) .self$.p <- v
})

test <- ClassWithPrivateField()
stopifnot(inherits(try(test$.p), "try-error"))
stopifnot(inherits(try(test$.p <- 2), "try-error"))
stopifnot(inherits(try(test[[".p"]]), "try-error"))
stopifnot(inherits(try(test[[".p"]] <- 2), "try-error"))
}
\seealso{
\link{Class}
}

