% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ao.R
\name{ao}
\alias{ao}
\title{Alternating Optimization}
\usage{
ao(
  f,
  npar,
  groups,
  sequence,
  iterlims,
  initial,
  minimize = TRUE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{f}{A function of \eqn{n} variables to be optimized.}

\item{npar}{An integer, the number \eqn{n} of variables of \code{f}.}

\item{groups}{A list of vectors of parameter indices \eqn{1,...,n} of \code{f}.
This determines the grouping of parameters.
Indices can be present in multiple groups.}

\item{sequence}{A vector of indices of the list \code{groups}.
This determines the sequence in which parameter groups get optimized.}

\item{iterlims}{A vector of iteration limits for the different optimization.
Must have the same length as \code{sequence}.
If not supplied, the default \link[stats]{nlm} setting is used.}

\item{initial}{A vector of length \eqn{n} of initial parameter values.
If not supplied, they are randomly drawn.}

\item{minimize}{A boolean, determining whether to minimize (\code{minimize = TRUE})
or to maximize (\code{minimize = FALSE}) the function \code{f}.}

\item{progress}{A boolean, determining whether progress should be printed.}

\item{...}{Arguments that get passed on to \link[stats]{nlm} (except for \code{iterlim}).}
}
\value{
A list containing the following components:
\item{optimum}{The optimal value of \code{f}.}
\item{estimate}{The parameter vector at which the optimum of \code{f} is obtained.}
\item{time}{The total optimization time.}
}
\description{
This function performs alternating optimization on the function \code{f}.
}
\examples{
ao(f = function(x) 3*x[1]^2 + 2*x[1]*x[2] + x[2]^2 - 5*x[1] + 2,
   npar = 2,
   groups = list(1,2),
   sequence = rep(c(1,2),10))
}
