% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.antaresDataList}
\alias{subset.antaresDataList}
\title{Subset an antaresDataList}
\usage{
\method{subset}{antaresDataList}(x, y = NULL, areas = NULL,
  timeIds = NULL, mcYears = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{antaresDataList} created with 
\code{\link{readAntares}}.}

\item{y}{A table containing at least one of the columns "area", "timeId" or 
"mcYear". If it is not \code{NULL}, then only tuples \code{(area, timeId,
mcYear)} present in this table are kept.}

\item{areas}{Vector of area names to keep in the result. If \code{NULL}, all 
areas are kept.}

\item{timeIds}{Vector of time ids to keep. If \code{NULL}, all time ids are 
kept.}

\item{mcYears}{Vector of monte-carlo years to keep. If \code{NULL}, all time 
ids are kept.}

\item{...}{Currently unused.}
}
\value{
A filtered \code{antaresDataList}.
}
\description{
Subset method for \code{antaresDataList}.
}
\examples{
\dontrun{
#keep only the first year
mydata <- readAntares(areas = "all", links = "all", mcYears = "all")
mySubset<-subset(mydata, mcYears = 1)
  
#keep only the first year for areas a and b 
mydata <- readAntares(areas = "all", links = "all", mcYears = "all")
mySubset<-subset(mydata, mcYears = 1, areas=c("a", "b")) 

#' #keep only the first year for areas a and b and timeIds include in 5:16 
mydata <- readAntares(areas = "all", links = "all", mcYears = "all")
mySubset<-subset(mydata, mcYears = 1, areas=c("a", "b"), timeIds=5:16) 
  
}

}
