% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesize.R
\name{synthesize}
\alias{synthesize}
\title{Synthesize Monte-Carlo scenarios}
\usage{
synthesize(x, ..., prefixForMeans = "")
}
\arguments{
\item{x}{an object of class \code{antaresData} created with
\code{\link[antaresRead]{readAntares}} and containing detailed results of
an Antares simulation.}

\item{...}{Additional parameters indicating which additional statistics to produce.
See details to see how to specify them.}

\item{prefixForMeans}{Prefix to add to the columns containing average values. If it is different
than "", a "_" is automatically added.}
}
\value{
Synthetic version of the input data. It has the same structure as \code{x}
except that column \code{mcYear} has been removed. All variables are
averaged across Monte-Carlo scenarios and eventually some additional columns
have been added corresponding to the requested custom statistics.
}
\description{
This function takes as input an object of class \code{antaresData} containing
detailed results of a simulation and creates a synthesis of the results.
The synthesis contains the average value of each variable over Monte-Carlo
scenarios and eventually other aggregated statistics
}
\details{
Additional statistics can be asked in three different ways:

\enumerate{
  \item A character string in "min", "max", "std", "median" or "qXXX" where
    "XXX" is a real number between 0 and 100. It will add
    for each column respectively the minimum or maximum value, the standard
    deviation, the median or a quantile.

  \item A named argument whose value is a function or one of the previous
    aliases. For instance \code{med = median} will calculate the median of
    each variable. The name of the resulting column will be prefixed by
    "med_". Similarly, \code{l = "q5"} will compute the 5%% quantile of
    each variable and put the result in a column with name prefixed by "l_"

  \item A named argument whose value is a list. It has to contain an element
  \code{fun} equal to a function or an alias and optionally an element
  \code{only} containing the names of the columns to which to apply the function.
  For instance \code{med = list(fun = median, only = c("LOAD", "MRG. PRICE"))}
  will compute the median of variables "LOAD" and "MRG. PRICE". The result
  will be stored in columns "med_LOAD" and "med_MRG. PRICE".
}

The computation of custom statistics can take some time, especially with hourly
data. To improve performance, prefer the third form and compute custom
statistics only on a few variables.
}
\examples{
\dontrun{
mydata <- readAntares("all", timeStep = "annual", synthesis = FALSE)

synthesize(mydata)

# Add minimum and maximum for all variables
synthesize(mydata, "min", "max")

# Compute a custom statistic for all columns
synthesize(mydata, log = function(x) mean(log(1 + x)))

# Same but only for column "LOAD"
synthesize(mydata,
           log = list(fun = function(x) mean(log(1 + x)),
                      only = "LOAD"))

# Compute the proportion of time balance is positive

synthesize(mydata, propPos = list(fun = function(x) mean(x > 0),
                                  only = "BALANCE"))

# Compute 95\% confidence interval for the marginal price
synthesize(mydata,
           l = list(fun = "q2.5", only = "MRG. PRICE"),
           u = list(fun = "q97.5", only = "MRG. PRICE"))
}

}
