% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_adjust.R
\name{mc_adjust}
\alias{mc_adjust}
\title{Multi-Collinearity Adjustment}
\usage{
mc_adjust(data, min_var = 0.1, max_cor = 0.9, action = "exclude")
}
\arguments{
\item{data}{named numeric data object (either data frame or matrix)}

\item{min_var}{numeric value between 0-1 for the minimum acceptable variance (default = 0.1)}

\item{max_cor}{numeric value between 0-1 for the maximum acceptable correlation (default = 0.9)}

\item{action}{select action for handling columns causing multi-collinearity issues
\enumerate{
   \item \code{exclude}: exclude all columns causing multi-collinearity issues (default)
   \item \code{select}: identify the columns causing multi-collinearity issues
     and allow the user to interactively select those columns to remove
 }}
}
\value{
\code{mc_adjust} returns the numeric data object supplied minus variables
  violating the minimum acceptable variance (\code{min_var}) and the
  maximum acceptable correlation (\code{max_cor}) levels.
}
\description{
\code{mc_adjust} handles issues with multi-collinearity.
}
\details{
\code{mc_adjust} handles issues with multi-collinearity by first removing
  any columns whose variance is close to or less than \code{min_var}. Then, it
  removes linearly dependent columns. Finally, it removes any columns that have
  a high absolute correlation value equal to or greater than \code{max_cor}.
}
\examples{
\dontrun{
x <- matrix(runif(100), ncol = 10)
x \%>\%
  mc_adjust()

x \%>\%
  mc_adjust(min_var = .15, max_cor = .75, action = "select")
}

}
