% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capa.R
\docType{methods}
\name{collective_anomalies}
\alias{collective_anomalies}
\alias{collective_anomalies,capa.class-method}
\alias{collective_anomalies,capa.uv.class-method}
\alias{collective_anomalies,capa.mv.class-method}
\title{Collective anomaly location, lags, and mean/variance changes.}
\usage{
\S4method{collective_anomalies}{capa.class}(object, merged = FALSE)

\S4method{collective_anomalies}{capa.uv.class}(object)

\S4method{collective_anomalies}{capa.mv.class}(object)
}
\arguments{
\item{object}{An S4 class produced by \code{\link{capa}}, \code{\link{capa.uv}} and \code{\link{capa.mv}}.}

\item{merged}{Boolean value. If \code{merged=TRUE} then collective anomalies that are common across multiple variates are merged together. This is useful when comparing the relative strength
of multivariate collective anomalies. Default value is \code{merged=FALSE}. Note - \code{merged=TRUE} is currently only available when \code{type="mean"}.}
}
\value{
A data frame.
}
\description{
Creates a data frame containing collective anomaly locations, lags and changes in mean and variance as detected by
\code{\link{capa.uv}}, \code{\link{capa.mv}}, and \code{\link{capa}}. 

For an object produced by \code{\link{capa.uv}}, \code{collective_anomalies} returns a data frame with columns containing the start and end position of the anomaly, the change in mean
due to the anomaly. When \code{type="meanvar"}, the change in variance due to the anomaly is also returned in an additional column.


For an object produced by \code{\link{capa.mv}}, \code{collective_anomalies} returns a data frame with columns containing the start and end position of the anomaly, the variates 
affected by the anomaly, as well as their the start and end lags. When \code{type="mean"} only the change in mean is reported. When \code{type="meanvar"} both the change in mean and
change in variance are included. If \code{merged=FALSE} (the default), then all the collective anomalies are processed individually even if they are common across multiple variates.
If \code{merged=TRUE}, then the collective anomalies are grouped together across all variates that they appear in.


For an object produced by \code{\link{capa}}, \code{collective_anomalies} returns the same results as \code{\link{capa.uv}} when the data is univariate, or the same results as
\code{\link{capa.mv}} when the data is multivariate.
}
\seealso{
\code{\link{capa}},\code{\link{capa.uv}},\code{\link{capa.mv}}.
}
