% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{annotation.merge}
\alias{annotation.merge}
\title{Annotation function (mulitple name)}
\usage{
annotation.merge(anno.names, ...)
}
\arguments{
\item{anno.names}{Annotation names, eg. c('avsnp138', 'avsnp147', '1000g2015aug_all')}

\item{...}{Other parameters see \code{\link{annotation}}}
}
\description{
Annotation function (mulitple name)
}
\examples{
library(data.table)
chr <- c('chr1', 'chr2', 'chr1')
start <- c('10020', '10020', '10020')
end <- c('10020', '10020', '10020')
ref <- c('A', 'A', 'A')
alt <- c('-', '-', '-')
database <- system.file('extdata', 'demo/hg19_avsnp147.txt', package = 'annovarR')
database.dir <- dirname(database)
dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
x <- annotation.merge(dat = dat, anno.names = c('avsnp147'), 
database.dir = database.dir, db.type = 'txt')
}
