% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crawl_interpolation.R
\name{crawl_interpolation}
\alias{crawl_interpolation}
\title{Single and Multiple Realizations Using crawl Package}
\usage{
crawl_interpolation(
  coord,
  delta.t,
  ID_names,
  max_refit_attempts,
  n.indiv,
  paths,
  paths.proj,
  paths.tranform.crs,
  simulation,
  simulation.iter,
  time.grid,
  Time.name
)
}
\arguments{
\item{coord}{A character vector of length 2 giving the names of the longitude/easting and latitude/northing columns in the \code{paths} \code{data.frame} (in that order). This is required if \code{paths} is not a \code{SpatialPointsDataFrame}.}

\item{delta.t}{The gap in time between each frame in the animation. Specify one of \code{delta.t} or \code{n.frames}. If both are specified, \code{delta.t} is used.}

\item{ID_names}{a list of names for each animal in the data}

\item{max_refit_attempts}{an integer of number of attempts per individual to fit crawl model}

\item{n.indiv}{an integer of the total number of unique animals in the data}

\item{paths}{A list of all paths from each animals stored in a \code{data.frame} or \code{SpatialPointsDataFrame} object.}

\item{paths.proj}{PROJ.4 string corresponding to the projection of the data}

\item{paths.tranform.crs}{a character string of CRS coordinate projection transformation based on the animals' location.}

\item{simulation}{logical. Generate simulation predictions to have multiple projects for the animal paths}

\item{simulation.iter}{an integer of how many paths the crawl model will generate}

\item{time.grid}{grid for synchronized interpolations}

\item{Time.name}{The name of the columns in \code{paths} gving the observation times. This column must be of class \code{POSIXt}, or numeric.}

\item{pt.colors}{A vector of colors to be used for each individual in the animation.}
}
\value{
interpolation values from crawl package
}
\description{
Single and Multiple Realizations Using crawl Package
}
\keyword{internal}
