% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-flip.r
\name{coord_flip}
\alias{coord_flip}
\title{Flipped cartesian coordinates.}
\usage{
coord_flip(xlim = NULL, ylim = NULL, expand = TRUE)
}
\arguments{
\item{xlim}{Limits for the x and y axes.}

\item{ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}
}
\description{
Flipped cartesian coordinates so that horizontal becomes vertical, and
vertical, horizontal. This is primarily useful for converting geoms and
statistics which display y conditional on x, to x conditional on y.
}
\examples{
h <- ggplot(diamonds, aes(carat)) +
  geom_histogram()
h
h + coord_flip()
h + coord_flip() + scale_x_reverse()

# You can also use it to flip line and area plots:
df <- data.frame(x = 1:5, y = (1:5) ^ 2)
ggplot(df, aes(x, y)) +
  geom_area()
last_plot() + coord_flip()
}
