% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firewalls.R
\name{firewall_add_droplets}
\alias{firewall_add_droplets}
\alias{firewall_remove_droplets}
\title{Add/remove droplets to a firewall}
\usage{
firewall_add_droplets(id, droplet_ids, ...)

firewall_remove_droplets(id, droplet_ids, ...)
}
\arguments{
\item{id}{(character) A firewall id (not the name) to delete}

\item{droplet_ids}{(integer/numeric) a vector of droplet ids}

\item{...}{Options passed on to httr::POST or httr::DELETE}
}
\description{
Add/remove droplets to a firewall
}
\examples{
\dontrun{
drops <- droplets_create()
drop_ids <- vapply(drops, "[[", numeric(1), "id")
inbound <- list(list(protocol = "tcp", ports = "80", 
  sources = list(addresses = "18.0.0.0/8")))
outbound <- list(list(protocol = "tcp", ports = "80", 
  destinations = list(addresses = "0.0.0.0/0")))
res <- firewall_create("myfirewall", inbound, outbound)
firewall_add_droplets(id = res$id, droplet_ids = drop_ids)
firewalls()[[1]]$droplet_ids
firewall_remove_droplets(id = res$id, droplet_ids = drop_ids)
}
}
