% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/droplet_reuse.R
\name{droplet_reuse}
\alias{droplet_reuse}
\title{Reuse a droplet or image by name}
\usage{
droplet_reuse(name, ...)
}
\arguments{
\item{name}{A name that could be a droplet or image name}

\item{...}{Named options passed on to \code{\link{droplet_create}}.}
}
\value{
A droplet
}
\description{
Reuse a droplet or image by name
}
\details{
Internally, we call the \code{\link{droplets}} and
\code{\link{images}} (with \code{private = TRUE}) to get list of your
droplets and images - and we check against those.
}
\examples{
\dontrun{
# matches droplet that exists
droplet_reuse(name = 'BeguiledAmmonia')

# matching image that exists
droplet_reuse(name = 'hadleyverse1', size = "1gb")

# no matching droplet or image
droplet_reuse(name = 'tablesandchairs')
}
}
