% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volumes.R
\name{as.volume}
\alias{as.volume}
\alias{volume}
\alias{volume_create}
\alias{volume_delete}
\alias{volume_snapshot_create}
\alias{volume_snapshots}
\alias{volumes}
\title{Block storage operations}
\usage{
as.volume(x)

volumes(...)

volume(volume, ...)

volume_create(name, size, description = NULL, region = "nyc1",
  snapshot_id = NULL, ...)

volume_snapshot_create(volume, name, ...)

volume_snapshots(volume, ...)

volume_delete(volume, ...)
}
\arguments{
\item{x}{Object to coerce to an volume}

\item{...}{Additional options passed down to \code{\link[httr]{GET}},
\code{\link[httr]{POST}}, etc.}

\item{volume}{A volume, or something that can be coerced to a volume by
\code{\link{as.volume}}.}

\item{name}{(character) Name of the new volume. required.}

\item{size}{(integer) The size of the Block Storage volume in GiB}

\item{description}{(character) An optional free-form text field to describe
a Block Storage volume.}

\item{region}{(character) The region where the Block Storage volume will
be created. When setting a region, the value should be the slug identifier
for the region. When you query a Block Storage volume, the entire region
object will be returned. Should not be specified with a snapshot_id.
Default: nyc1}

\item{snapshot_id}{(integer) The unique identifier for the volume snapshot
from which to create the volume. Should not be specified with a region_id.}
}
\description{
\describe{
 \item{volume}{get a single volume}
 \item{volumes}{list volumes}
 \item{volume_create}{create a volume}
 \item{volume_snapshot_create}{create a snapshot of a volume}
 \item{volume_snapshots}{list snapshots for a volume}
 \item{volume_delete}{delete a volume}
}
}
\details{
note that if you delete a volume, and it has a snapshot, the
snapshot still exists, so beware
}
\examples{
\dontrun{
# list volumes
volumes()

# create a volume
vol1 <- volume_create('testing', 5)
vol2 <- volume_create('foobar', 6)

# create snapshot of a volume
xx <- volume_snapshot_create(vol2, "howdy")

# list snaphots for a volume
volume_snapshots(xx)

# list volumes again
res <- volumes()

# get a single volume
## a whole volume class object
volume(res$testing)
## by id
volume(res[[1]]$id)
## by name
volume(res[[1]]$name)

# delete a volume
## a whole volume class object
volume_delete(res$testing)
## by id
volume_delete(res[[1]]$id)
## by name
volume_delete(res[[1]]$name)

# delete many volumes
lapply(volumes(), volume_delete)
}
}

