% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/droplet-actions.R
\name{droplet_delete}
\alias{droplet_delete}
\title{Delete a droplet.}
\usage{
droplet_delete(droplet = NULL, tag = NULL, ...)
}
\arguments{
\item{droplet}{A droplet, or something that can be coerced to a droplet by
\code{\link{as.droplet}}.}

\item{tag}{(character) Name of a tag. optional}

\item{...}{Additional options passed down to low-level API method.}
}
\description{
This method deletes one of your droplets - this is irreversible.
}
\examples{
\dontrun{
drops <- droplets()
drops[[1]] \%>\% droplet_delete()
drops[[2]] \%>\% droplet_delete()
droplet_create() \%>\% droplet_delete()

droplet_delete("lombard")
droplet_delete(12345)

# Delete all droplets
lapply(droplets(), droplet_delete)

# delete droplets by tag
## first, create a tag, then a droplet, then tag it
tag_create(name = "foobar")
e <- droplet_create()
tag_resource(name = "foobar", resource_id = e$id)
droplets(tag = "foobar")
## then delete the droplet by tag name
droplet_delete(tag = "foobar")
}
}

