% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{make_start}
\alias{make_start}
\alias{make_start.numeric}
\alias{make_start.track_xyt}
\alias{make_start.steps_xyt}
\title{Create an initial step for simulations}
\usage{
make_start(x, ...)

\method{make_start}{numeric}(
  x = c(0, 0),
  ta_ = 0,
  time = Sys.time(),
  dt = hours(1),
  crs = NA,
  ...
)

\method{make_start}{track_xyt}(x, ta_ = 0, dt = hours(1), ...)

\method{make_start}{steps_xyt}(x, ...)
}
\arguments{
\item{x}{\verb{[steps_xyt,numeric(2)]} \cr A step of class \code{steps_xyt} or the start coordinates..}

\item{...}{Further arguments, none implemented.}

\item{ta_}{\verb{[numeric(1)]\{0\}} \cr The initial turn-angle.}

\item{time}{\verb{[POSIXt(1)]\{Sys.time()\}} \cr The time stamp when the simulation
starts.}

\item{dt}{\verb{[Period(1)]\{hours(1)\}} \cr The sampling rate of the
simulations.}

\item{crs}{\verb{[int(1)]\{NA\}} \cr The coordinate reference system of the start location given as EPSG code.}
}
\description{
An initial step for simulations. This step can either be created by defining a step from
scratch or by using an observed step.
}
