% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_rss.R
\name{plot.log_rss}
\alias{plot.log_rss}
\title{Plot a \code{log_rss} object}
\usage{
\method{plot}{log_rss}(x, x_var1 = "guess", x_var2 = "guess", ...)
}
\arguments{
\item{x}{\verb{[log_rss]} An object returned by the function \code{\link{log_rss}()}.}

\item{x_var1}{\verb{[character]} The variable to plot on the x-axis. A string of
either \code{"guess"} (default -- see Details) or the variable name.}

\item{x_var2}{\verb{[character]} A second predictor variable to include in the plot.
Either \code{"guess"} (default -- see Details), \code{NA}, or the variable name.}

\item{...}{\verb{[any]} Additional arguments to be passed to \verb{\link{plot}()}.
\emph{Not currently implemented}.}
}
\value{
A plot.
}
\description{
Default plot method for an object of class \code{log_rss}
}
\details{
This function provides defaults for a basic plot, but we encourage
the user to carefully consider how to represent the patterns found in their
habitat selection model.

The function \code{\link{log_rss}()} is meant to accept a user-defined
input for \code{x1}. The structure of \code{x1} likely reflects how the user intended
to visualize the results. Therefore, it is possible to "guess" which covariate
the user would like to see on the x-axis by choosing the column from \code{x1} with
the most unique values. Similarly, if there is a second column with multiple
unique values, that could be represented by a color. Note that if the user needs
to specify \code{x_var1}, then we probably cannot guess \code{x_var2}. Therefore, if the
user specifies \code{x_var1 != "guess" & x_var2 == "guess"}, the function will return
an error.

This function uses integers to represent colors, and therefore the user can
change the default colors by specifying a custom \code{\link{palette}()} before
calling the function.
}
\examples{
\donttest{
# Load data
data("amt_fisher")
data("amt_fisher_covar")

# Prepare data for RSF
rsf_data <- amt_fisher \%>\%
  filter(name == "Leroy") \%>\%
  make_track(x_, y_, t_) \%>\%
  random_points() \%>\%
  extract_covariates(amt_fisher_covar$landuse) \%>\%
  mutate(lu = factor(landuse))

# Fit RSF
m1 <- rsf_data \%>\%
  fit_rsf(case_ ~ lu)

# Calculate log-RSS
# data.frame of x1s
x1 <- data.frame(lu = sort(unique(rsf_data$lu)))
# data.frame of x2 (note factor levels should be same as model data)
x2 <- data.frame(lu = factor(140,
levels = levels(rsf_data$lu)))
# Calculate
logRSS <- log_rss(object = m1, x1 = x1, x2 = x2)

# Plot
plot(logRSS)
}

}
