% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda_sampling_rate.R
\name{summarize_sampling_rate}
\alias{summarize_sampling_rate}
\alias{summarize_sampling_rate.track_xyt}
\title{Returns a summary of sampling rates}
\usage{
summarize_sampling_rate(x, ...)

\method{summarize_sampling_rate}{track_xyt}(x, time_unit = "auto",
  summarize = TRUE, as_tibble = TRUE, ...)
}
\arguments{
\item{x}{A \code{track_xyt}.}

\item{...}{Further arguments, none implemented.}

\item{time_unit}{A character. The time unit in which the sampling rate is
calculated. Acceptable values are \code{sec}, \code{min}, \code{hour}, \code{day}, and \code{auto}.
If \code{auto} (the default) is used, the optimal unit is guessed.}

\item{summarize}{A logical. If \code{TRUE} a summary is returned, otherwise raw
sampling intervals are returned.}

\item{as_tibble}{A logical. Should result be returned as \code{tibble} or as
\code{table}.}
}
\value{
Depending on \code{summarize} and \code{as_tibble}, a vector, table or tibble.
}
\description{
Returns a summary of sampling rates
}
\examples{
data(deer)
amt::summarize_sampling_rate(deer)

}
