% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{Response}
\alias{Response}
\title{Response}
\description{
Response class to generate responses sent from the server.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-status}{\code{Response$status()}}
\item \href{#method-send}{\code{Response$send()}}
\item \href{#method-sendf}{\code{Response$sendf()}}
\item \href{#method-text}{\code{Response$text()}}
\item \href{#method-send_file}{\code{Response$send_file()}}
\item \href{#method-redirect}{\code{Response$redirect()}}
\item \href{#method-render}{\code{Response$render()}}
\item \href{#method-json}{\code{Response$json()}}
\item \href{#method-csv}{\code{Response$csv()}}
\item \href{#method-tsv}{\code{Response$tsv()}}
\item \href{#method-htmlwidget}{\code{Response$htmlwidget()}}
\item \href{#method-md}{\code{Response$md()}}
\item \href{#method-header}{\code{Response$header()}}
\item \href{#method-print}{\code{Response$print()}}
\item \href{#method-set}{\code{Response$set()}}
\item \href{#method-get}{\code{Response$get()}}
\item \href{#method-get_headers}{\code{Response$get_headers()}}
\item \href{#method-pre_render_hook}{\code{Response$pre_render_hook()}}
\item \href{#method-post_render_hook}{\code{Response$post_render_hook()}}
\item \href{#method-cookie}{\code{Response$cookie()}}
\item \href{#method-clone}{\code{Response$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-status"></a>}}
\if{latex}{\out{\hypertarget{method-status}{}}}
\subsection{Method \code{status()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$status(status)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{An integer defining the status.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set the status of the response.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send"></a>}}
\if{latex}{\out{\hypertarget{method-send}{}}}
\subsection{Method \code{send()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$send(
  body,
  headers = list(`Content-Type` = "text/html"),
  status = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{Body of the response.}

\item{\code{headers}}{HTTP headers to set.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Send a plain HTML response.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sendf"></a>}}
\if{latex}{\out{\hypertarget{method-sendf}{}}}
\subsection{Method \code{sendf()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$sendf(
  body,
  ...,
  headers = list(`Content-Type` = "text/html"),
  status = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{Body of the response.}

\item{\code{...}}{Passed to \code{...} of \code{sprintf}.}

\item{\code{headers}}{HTTP headers to set.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Send a plain HTML response, pre-processed with sprintf.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-text"></a>}}
\if{latex}{\out{\hypertarget{method-text}{}}}
\subsection{Method \code{text()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$text(
  body,
  headers = list(`Content-Type` = "text/plain"),
  status = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{Body of the response.}

\item{\code{headers}}{HTTP headers to set.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Send a plain text response.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send_file"></a>}}
\if{latex}{\out{\hypertarget{method-send_file}{}}}
\subsection{Method \code{send_file()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$send_file(
  file,
  headers = list(`Content-Type` = "text/html"),
  status = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{File to send.}

\item{\code{headers}}{HTTP headers to set.}

\item{\code{status}}{Status of the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Send a file.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-redirect"></a>}}
\if{latex}{\out{\hypertarget{method-redirect}{}}}
\subsection{Method \code{redirect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$redirect(path, status = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path or URL to redirect to.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Redirect to a path or URL.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-render"></a>}}
\if{latex}{\out{\hypertarget{method-render}{}}}
\subsection{Method \code{render()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$render(
  file,
  data = list(),
  headers = list(`Content-Type` = "text/html"),
  status = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{Template file.}

\item{\code{data}}{List to fill \verb{[\% tags \%]}.}

\item{\code{headers}}{HTTP headers to set.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Render a template file.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-json"></a>}}
\if{latex}{\out{\hypertarget{method-json}{}}}
\subsection{Method \code{json()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$json(
  body,
  headers = list(`Content-Type` = "application/json"),
  status = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{Body of the response.}

\item{\code{headers}}{HTTP headers to set.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}

\item{\code{...}}{Additional arguments passed to the serialiser.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Render an object as JSON.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-csv"></a>}}
\if{latex}{\out{\hypertarget{method-csv}{}}}
\subsection{Method \code{csv()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$csv(data, name = "data", status = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Data to convert to CSV.}

\item{\code{name}}{Name of the file.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}

\item{\code{...}}{Additional arguments passed to \code{\link[readr:format_delim]{readr::format_csv()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sends a comma separated value file
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tsv"></a>}}
\if{latex}{\out{\hypertarget{method-tsv}{}}}
\subsection{Method \code{tsv()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$tsv(data, name = "data", status = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Data to convert to CSV.}

\item{\code{name}}{Name of the file.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}

\item{\code{...}}{Additional arguments passed to \code{\link[readr:format_delim]{readr::format_tsv()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sends a tab separated value file
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-htmlwidget"></a>}}
\if{latex}{\out{\hypertarget{method-htmlwidget}{}}}
\subsection{Method \code{htmlwidget()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$htmlwidget(widget, status = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{widget}}{The widget to use.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}

\item{\code{...}}{Additional arguments passed to \code{\link[htmlwidgets:saveWidget]{htmlwidgets::saveWidget()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sends an htmlwidget.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-md"></a>}}
\if{latex}{\out{\hypertarget{method-md}{}}}
\subsection{Method \code{md()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$md(
  file,
  data = list(),
  headers = list(`Content-Type` = "text/html"),
  status = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{Template file.}

\item{\code{data}}{List to fill \verb{[\% tags \%]}.}

\item{\code{headers}}{HTTP headers to set.}

\item{\code{status}}{Status of the response, if \code{NULL} uses \code{self$status}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Render a markdown file.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-header"></a>}}
\if{latex}{\out{\hypertarget{method-header}{}}}
\subsection{Method \code{header()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$header(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name, value}}{Name and value of the header.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Add headers to the response.
}

\subsection{Returns}{
Invisibly returns self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set"></a>}}
\if{latex}{\out{\hypertarget{method-set}{}}}
\subsection{Method \code{set()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$set(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the variable.}

\item{\code{value}}{Value of the variable.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set Data
}

\subsection{Returns}{
Invisible returns self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$get(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the variable to get.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get data
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_headers"></a>}}
\if{latex}{\out{\hypertarget{method-get_headers}{}}}
\subsection{Method \code{get_headers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$get_headers()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get headers
Returns the list of headers currently set.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pre_render_hook"></a>}}
\if{latex}{\out{\hypertarget{method-pre_render_hook}{}}}
\subsection{Method \code{pre_render_hook()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$pre_render_hook(hook)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hook}}{A function that accepts at least 4 arguments:
\itemize{
\item \code{self}: The \code{Request} class instance.
\item \code{content}: File content a vector of character string,
content of the template.
\item \code{data}: \code{list} passed from \code{render} method.
\item \code{ext}: File extension of the template file.
}

This function is used to add pre-render hooks to the \code{render}
method. The function should return an object of class
\code{responsePreHook} as obtained by \code{\link[=pre_hook]{pre_hook()}}.
This is meant to be used by middlewares to, if necessary,
pre-process rendered data.

Include \code{...} in your \code{hook} to ensure it will handle
potential updates to hooks in the future.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Add a pre render hook.
Runs before the \code{render} and \code{send_file} method.
}

\subsection{Returns}{
Invisible returns self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-post_render_hook"></a>}}
\if{latex}{\out{\hypertarget{method-post_render_hook}{}}}
\subsection{Method \code{post_render_hook()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$post_render_hook(hook)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hook}}{A function to run after the rendering of HTML.
It should accept at least 3 arguments:
\itemize{
\item \code{self}: The \code{Request} class instance.
\item \code{content}: File content a vector of character string,
content of the template.
\item \code{ext}: File extension of the template file.
}

Include \code{...} in your \code{hook} to ensure it will handle
potential updates to hooks in the future.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Post render hook.
}

\subsection{Returns}{
Invisible returns self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cookie"></a>}}
\if{latex}{\out{\hypertarget{method-cookie}{}}}
\subsection{Method \code{cookie()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$cookie(
  name,
  value,
  expires = NULL,
  max_age = NULL,
  domain = NULL,
  path = NULL,
  secure = TRUE,
  http_only = FALSE,
  same_site = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the cookie.}

\item{\code{value}}{value of the cookie.}

\item{\code{expires}}{Expiry, if an integer assumes it's the number of seconds
from now. Otherwise accepts an object of class \code{POSIXct} or \code{Date}.
If unspecified, the cookie becomes a session cookie. A session finishes
when the client shuts down, after which the session cookie is removed.}

\item{\code{max_age}}{Indicates the number of seconds until the cookie expires.
A zero or negative number will expire the cookie immediately.
If both \code{expires} and \code{max_age} are set, the latter has precedence.}

\item{\code{domain}}{Defines the host to which the cookie will be sent.
If omitted, this attribute defaults to the host of the current document URL,
not including subdomains.}

\item{\code{path}}{Indicates the path that must exist in the requested URL for the
browser to send the Cookie header.}

\item{\code{secure}}{Indicates that the cookie is sent to the server only when a
request is made with the https: scheme (except on localhost), and therefore,
is more resistant to man-in-the-middle attacks.}

\item{\code{http_only}}{Forbids JavaScript from accessing the cookie, for example,
through the Document.cookie property.}

\item{\code{same_site}}{Controls whether or not a cookie is sent with cross-origin
requests, providing some protection against cross-site request forgery
attacks (CSRF). Accepts \code{Strict}, \code{Lax}, or \code{None}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set a cookie
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
