% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFluxnetStats.R
\name{plotFluxnetStats}
\alias{plotFluxnetStats}
\title{Plots that show statistical metrics for FLUXNET sites}
\usage{
plotFluxnetStats(inputDir, outputDir = FALSE, mod.id = "CLASSIC",
  variableNames = c("GPP", "RECO", "NEE", "RNS", "HFLS", "HFSS"),
  plot.width = 12, plot.height = 8)
}
\arguments{
\item{inputDir}{A string that gives the location of text files produced by \link{scores.fluxnet.csv}, e.g. '/home/project/study'.}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{mod.id}{A string that identifies the source of the reference data set, e.g. 'CLASSIC'}

\item{variableNames}{A string of six variables that should be plotted. Default is set to c('GPP', 'RECO', 'NEE', 'RNS', 'HFLS', 'HFSS').}

\item{plot.width}{Number that gives the plot width, e.g. 12}

\item{plot.height}{Number that gives the plot height, e.g. 8}
}
\value{
Figures that show statistical metrics produced by the function \link{scores.fluxnet.csv}. The function expects six input variables.
}
\description{
This function plots statistical metrics for the comparison against FLUXNET data.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

inputDir <- paste(system.file('extdata', package = 'amber'), 'scores', sep = '/')
plotFluxnetStats(inputDir, outputDir = FALSE, mod.id = 'CLASSIC.CRUJRAv2')

}
