% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatenation.R
\name{altair_concatenation}
\alias{altair_concatenation}
\alias{|.altair.vegalite.v4.api.TopLevelMixin}
\alias{+.altair.vegalite.v4.api.TopLevelMixin}
\alias{&.altair.vegalite.v4.api.TopLevelMixin}
\title{Altair plot concatenation}
\usage{
\method{|}{altair.vegalite.v4.api.TopLevelMixin}(e1, e2)

\method{+}{altair.vegalite.v4.api.TopLevelMixin}(e1, e2)

\method{&}{altair.vegalite.v4.api.TopLevelMixin}(e1, e2)
}
\arguments{
\item{e1}{Altair chart object}

\item{e2}{Altair chart object}
}
\value{
Compound Altair chart object
}
\description{
Altair plots can be concatenated using the following operators:
\code{+}, \code{|}, and \code{&}
}
\examples{

if (interactive()){

  # Examples using the beaver1 and beaver2 body temperature data sets
  # Layering Charts
  base <- alt$Chart(beaver1)$encode(
    x = alt$X('time'),
    y = alt$Y('temp', scale = alt$Scale(zero = FALSE))
  )

  scatter_plot <- base$mark_point()
  line_plot <- base$mark_line()

  combined_plot <- scatter_plot + line_plot

  # Horizontal Concatenation
  base2 <- alt$Chart(beaver2)$
    encode(
      x = alt$X("time"),
      y = alt$Y("temp", scale = alt$Scale(zero = FALSE))
    )

  scatter_plot2 <- base2$mark_point()
  line_plot2 <- base2$mark_line()

  combined_plot <-
    (scatter_plot + line_plot)$
    properties(title = "Beaver 1", width = 200)

  combined_plot2 <-
    (scatter_plot2 + line_plot2)$
    properties(title = "Beaver 2", width = 200)

  hconcat_plot <- combined_plot | combined_plot2

  # Vertical Concatenation
  vconcat_plot <- combined_plot & combined_plot2

}

}
