% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_get.R
\name{av_get}
\alias{av_get}
\title{Get financial data from the Alpha Vantage API}
\usage{
av_get(symbol = NULL, av_fun, ...)
}
\arguments{
\item{symbol}{A character string of an appropriate stock or fund.
See parameter "symbol" in \href{https://www.alphavantage.co/documentation/}{Alpha Vantage API documentation}.}

\item{av_fun}{A character string matching an appropriate Alpha Vantage "function".
See parameter "function" in \href{https://www.alphavantage.co/documentation/}{Alpha Vantage API documentation}.}

\item{...}{Additional parameters passed to the Alpha Vantage API.
For a list of parameters, visit the \href{https://www.alphavantage.co/documentation/}{Alpha Vantage API documentation}.}
}
\value{
Returns a tibble of financial data
}
\description{
Get financial data from the Alpha Vantage API
}
\examples{
\dontrun{
av_api_key("YOUR_API_KEY")
av_get(symbol = "MSFT", av_fun = "TIME_SERIES_INTRADAY", interval = "15min", outputsize = "full")
}


}
\seealso{
\code{\link[=av_api_key]{av_api_key()}}
}
