% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alma-events.R
\name{alma_events}
\alias{alma_events}
\title{Get all events}
\usage{
alma_events(rschedule)
}
\arguments{
\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule or rbundle.}
}
\value{
A Date vector of events.
}
\description{
\code{alma_events()} retrieves all of the events in the rschedule's
event set.
}
\examples{
rrule <- daily(since = "1970-01-01", until = "1970-01-05")

alma_events(rrule)

rrule_weekly <- weekly(since = "1970-01-01") \%>\%
  recur_for_count(5)

rb <- runion() \%>\%
  add_rschedule(rrule) \%>\%
  add_rschedule(rrule_weekly)

alma_events(rb)
}
